/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.overlays;

import com.toofifty.easyblastfurnace.EasyBlastFurnaceConfig;
import com.toofifty.easyblastfurnace.EasyBlastFurnacePlugin;
import com.toofifty.easyblastfurnace.utils.RSNumberFormat;
import com.toofifty.easyblastfurnace.utils.SessionStatistics;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.LineComponent;

@Singleton
public class StatisticsOverlay
extends OverlayPanel {
    public static final String CLEAR_ACTION = "Clear";
    @Inject
    private SessionStatistics statistics;
    @Inject
    private EasyBlastFurnaceConfig config;
    private final EasyBlastFurnacePlugin plugin;

    @Inject
    StatisticsOverlay(EasyBlastFurnacePlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, CLEAR_ACTION, "Easy blast furnace statistics"));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Easy blast furnace statistics"));
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        if (!this.config.showStatisticsOverlay()) {
            return null;
        }
        if (this.config.showBarsTodo()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Bars todo:").right(RSNumberFormat.format(this.statistics.getTotalActionsBanked())).build());
        }
        if (this.config.showBarsMade()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Bars made:").right(RSNumberFormat.format(this.statistics.getTotalActionsDone())).build());
        }
        if (this.config.showBarsPerHour()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Bars/hr:").right(RSNumberFormat.format(this.statistics.getBarsPerHour())).build());
        }
        if (this.config.showXpBanked()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("XP banked:").right(RSNumberFormat.format(this.statistics.getTotalXpBanked())).build());
        }
        if (this.config.showXpGained()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("XP gained:").right(RSNumberFormat.format(this.statistics.getTotalXpGained())).build());
        }
        if (this.config.showStaminaDoses()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Stamina doses:").right(RSNumberFormat.format(this.statistics.getStaminaDoses())).build());
        }
        return super.render(graphics);
    }
}

