/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.overlays;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.toofifty.easyblastfurnace.EasyBlastFurnaceConfig;
import com.toofifty.easyblastfurnace.config.HighlightOverlayTextSetting;
import com.toofifty.easyblastfurnace.steps.MethodStep;
import com.toofifty.easyblastfurnace.steps.ObjectStep;
import com.toofifty.easyblastfurnace.utils.MethodHandler;
import com.toofifty.easyblastfurnace.utils.ObjectManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import net.runelite.api.GameObject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.TextComponent;

@Singleton
public class ObjectStepOverlay
extends Overlay {
    @Inject
    private ObjectManager objectManager;
    @Inject
    private EasyBlastFurnaceConfig config;
    @Inject
    private MethodHandler methodHandler;

    ObjectStepOverlay() {
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showObjectOverlays()) {
            return null;
        }
        MethodStep[] steps = this.methodHandler.getSteps();
        if (steps == null) {
            return null;
        }
        for (MethodStep step : steps) {
            if (!(step instanceof ObjectStep)) continue;
            Color color = this.config.objectOverlayColor();
            GameObject object = this.objectManager.get(((ObjectStep)step).getObjectId());
            Shape clickBox = object.getClickbox();
            if (clickBox == null) continue;
            graphics.setColor(color);
            graphics.draw(clickBox);
            graphics.setColor(new Color(color.getRed(), color.getBlue(), color.getGreen(), 20));
            graphics.fill(clickBox);
            if (this.config.objectOverlayTextMode() == HighlightOverlayTextSetting.NONE) continue;
            TextComponent textComponent = new TextComponent();
            Rectangle bounds = object.getClickbox().getBounds();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int textWidth = fontMetrics.stringWidth(step.getTooltip());
            int textHeight = fontMetrics.getHeight();
            if (this.config.objectOverlayTextMode() == HighlightOverlayTextSetting.ABOVE) {
                textComponent.setPosition(new Point(bounds.x + bounds.width / 2 - textWidth / 2, bounds.y - textHeight));
            } else {
                textComponent.setPosition(new Point(bounds.x + bounds.width / 2 - textWidth / 2, bounds.y + bounds.height));
            }
            textComponent.setColor(color);
            textComponent.setText(step.getTooltip());
            textComponent.render(graphics);
        }
        return null;
    }
}

