/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.overlays;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.toofifty.easyblastfurnace.EasyBlastFurnaceConfig;
import com.toofifty.easyblastfurnace.config.HighlightOverlayTextSetting;
import com.toofifty.easyblastfurnace.config.ItemOverlaySetting;
import com.toofifty.easyblastfurnace.steps.ItemStep;
import com.toofifty.easyblastfurnace.steps.MethodStep;
import com.toofifty.easyblastfurnace.utils.MethodHandler;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import net.runelite.api.Client;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.TextComponent;

@Singleton
public class ItemStepOverlay
extends WidgetItemOverlay {
    @Inject
    Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private EasyBlastFurnaceConfig config;
    @Inject
    private MethodHandler methodHandler;
    public static boolean itemInBank = true;
    public static WidgetItem currentWidgetItem;

    ItemStepOverlay() {
        this.showOnInventory();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        if (this.config.itemOverlayMode() == ItemOverlaySetting.NONE) {
            return;
        }
        MethodStep[] steps = this.methodHandler.getSteps();
        int finalItemId = itemId;
        if (steps == null) {
            return;
        }
        for (MethodStep step : steps) {
            if (!(step instanceof ItemStep)) continue;
            if (currentWidgetItem != null) {
                widgetItem = currentWidgetItem;
                itemId = widgetItem.getWidget().getItemId();
            } else if (Arrays.stream(((ItemStep)step).getItemIds()).noneMatch(id -> id == finalItemId)) continue;
            currentWidgetItem = widgetItem;
            Color color = this.config.itemOverlayColor();
            Rectangle bounds = widgetItem.getCanvasBounds();
            if (this.config.itemOverlayMode() == ItemOverlaySetting.OUTLINE) {
                BufferedImage outline = this.itemManager.getItemOutline(itemId, widgetItem.getQuantity(), color);
                ImageComponent imageComponent = new ImageComponent(outline);
                imageComponent.setPreferredLocation(new Point(bounds.x, bounds.y));
                imageComponent.render(graphics);
            } else {
                graphics.setColor(color);
                graphics.draw(bounds);
            }
            if (this.config.itemOverlayTextMode() == HighlightOverlayTextSetting.NONE) continue;
            TextComponent textComponent = new TextComponent();
            textComponent.setColor(color);
            textComponent.setText(step.getTooltip());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int textWidth = fontMetrics.stringWidth(step.getTooltip());
            int textHeight = fontMetrics.getHeight();
            if (this.config.itemOverlayTextMode() == HighlightOverlayTextSetting.BELOW) {
                textComponent.setPosition(new Point(bounds.x + bounds.width / 2 - textWidth / 2, bounds.y + bounds.height + textHeight));
            } else {
                textComponent.setPosition(new Point(bounds.x + bounds.width / 2 - textWidth / 2, bounds.y - textHeight / 2));
            }
            textComponent.render(graphics);
        }
    }
}

