/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.overlays;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.toofifty.easyblastfurnace.EasyBlastFurnaceConfig;
import com.toofifty.easyblastfurnace.EasyBlastFurnacePlugin;
import com.toofifty.easyblastfurnace.methods.Method;
import com.toofifty.easyblastfurnace.state.BlastFurnaceState;
import com.toofifty.easyblastfurnace.steps.MethodStep;
import com.toofifty.easyblastfurnace.utils.MethodHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

@Singleton
public class InstructionOverlay
extends OverlayPanel {
    public static final String RESET_ACTION = "Reset";
    private static final Color TOOLTIP_COLOR = new Color(190, 190, 190);
    private final EasyBlastFurnacePlugin plugin;
    @Inject
    private EasyBlastFurnaceConfig config;
    @Inject
    private BlastFurnaceState state;
    @Inject
    private MethodHandler methodHandler;

    @Inject
    InstructionOverlay(EasyBlastFurnacePlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, RESET_ACTION, "Easy blast furnace overlay"));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Easy blast furnace overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        if (!this.config.showStepOverlay()) {
            return null;
        }
        Method method = this.methodHandler.getMethod();
        MethodStep[] steps = this.methodHandler.getSteps();
        int index = 0;
        if (steps == null) {
            return null;
        }
        for (MethodStep step : steps) {
            String tooltip;
            String methodName;
            String string = methodName = method != null ? method.getName() : "No method selected";
            String string2 = this.state.getPlayer().isOnBlastFurnaceWorld() ? (step != null ? step.getTooltip() : "Withdraw an ore from the bank to start. You can start a hybrid method by also withdrawing gold ore.") : (tooltip = "You need to be on a Blast Furnace themed world to use this plugin.");
            if (index == 0) {
                this.panelComponent.getChildren().add(TitleComponent.builder().text("Easy Blast Furnace").build());
                this.panelComponent.getChildren().add(LineComponent.builder().left(methodName).leftColor(this.config.itemOverlayColor()).build());
            }
            ++index;
            this.panelComponent.getChildren().add(LineComponent.builder().left(tooltip).leftColor(TOOLTIP_COLOR).build());
        }
        return super.render(graphics);
    }
}

