/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.overlays;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.toofifty.easyblastfurnace.EasyBlastFurnaceConfig;
import com.toofifty.easyblastfurnace.EasyBlastFurnacePlugin;
import com.toofifty.easyblastfurnace.state.BlastFurnaceState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;

@Singleton
public class CoalBagOverlay
extends WidgetItemOverlay {
    @Inject
    private EasyBlastFurnacePlugin plugin;
    @Inject
    private EasyBlastFurnaceConfig config;
    @Inject
    private BlastFurnaceState state;

    CoalBagOverlay() {
        this.showOnInventory();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        if (!this.plugin.isEnabled()) {
            return;
        }
        if (itemId != 764 && itemId != 12019 && itemId != 25627 && itemId != 24480) {
            return;
        }
        if (!this.config.showCoalBagOverlay()) {
            return;
        }
        Color color = this.config.coalBagOverlayColor();
        Rectangle bounds = widgetItem.getCanvasBounds();
        TextComponent textComponent = new TextComponent();
        textComponent.setPosition(new Point(bounds.x - 1, bounds.y + 8));
        textComponent.setColor(color);
        textComponent.setText(Integer.toString(this.state.getCoalBag().getCoal()));
        textComponent.render(graphics);
    }
}

