/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.methods;

import com.toofifty.easyblastfurnace.methods.MetalBarMethod;
import com.toofifty.easyblastfurnace.state.BlastFurnaceState;
import com.toofifty.easyblastfurnace.steps.MethodStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GoldHybridMethod
extends MetalBarMethod {
    private static final Logger log = LoggerFactory.getLogger(GoldHybridMethod.class);
    protected boolean lastInvWasGold = false;

    private MethodStep[] checkPrerequisite(BlastFurnaceState state) {
        if (!state.getInventory().has(12019, 24480)) {
            if (state.getInventory().has(this.oreItem(), 444)) {
                return state.getConfig().useDepositInventory() ? this.depositInventory : this.depositBarsAndOres;
            }
            return state.getBank().isOpen() ? this.withdrawCoalBag : this.openBank;
        }
        if (!state.getInventory().has(1580, 27031) && !state.getEquipment().hasIceGlovesEffect()) {
            return state.getBank().isOpen() ? this.withdrawIceOrSmithsGloves : this.openBank;
        }
        if (state.getBank().has(13280) && !state.getInventory().has(13280) && !state.getEquipment().equipped(13280)) {
            return state.getBank().isOpen() ? this.withdrawMaxCape : this.openBank;
        }
        if (state.getInventory().has(13280) && !state.getEquipment().equipped(13280)) {
            return this.equipMaxCape;
        }
        if (state.getBank().has(9795, 9796) && !state.getInventory().has(9795, 9796) && !state.getEquipment().equipped(9795, 9796, 13280)) {
            return state.getBank().isOpen() ? this.withdrawSmithingCape : this.openBank;
        }
        if (state.getInventory().has(9795, 9796) && !state.getEquipment().equipped(9795, 9796, 13280)) {
            return this.equipSmithingCape;
        }
        if (!state.getInventory().has(776) && !state.getEquipment().hasGoldsmithEffect()) {
            return state.getBank().isOpen() ? this.withdrawGoldsmithGauntlets : this.openBank;
        }
        if (!state.getEquipment().hasIceGlovesEffect() && !state.getEquipment().hasGoldsmithEffect()) {
            return this.equipGoldsmithGauntlets;
        }
        return null;
    }

    @Override
    public MethodStep[] next(BlastFurnaceState state) {
        boolean needToCollectBars;
        MethodStep[] prerequisite = this.checkPrerequisite(state);
        if (prerequisite != null) {
            return prerequisite;
        }
        boolean smithingCapeEquipped = state.getEquipment().equipped(9795, 9796);
        int maxCoalInventory = state.getInventory().getFreeSlotsIncludingOresAndBars();
        boolean coalRun = state.getFurnace().getQuantity(453) < maxCoalInventory * (this.coalPer() - state.getFurnace().getCoalOffset());
        boolean oreOnConveyor = state.getPlayer().hasOreOnConveyor();
        boolean furnaceHasGoldBar = state.getFurnace().has(2357);
        boolean furnaceHasGoldOre = state.getFurnace().has(444);
        boolean furnaceHasMetalBar = state.getFurnace().has(this.barItem());
        boolean furnaceHasMetalOre = state.getFurnace().has(this.oreItem());
        boolean furnaceHasBar = state.getFurnace().has(this.barItem(), 2357);
        boolean tickPerfectMethod = state.getConfig().tickPerfectMethod();
        boolean coalBagFull = state.getCoalBag().isFull();
        boolean coalBagEmpty = state.getCoalBag().isEmpty();
        boolean atBarDispenser = state.getPlayer().isAtBarDispenser();
        boolean atConveyorBelt = state.getPlayer().isAtConveyorBelt();
        boolean useDepositInventory = state.getConfig().useDepositInventory();
        boolean fullOfMetalBarsAndOres = state.getFurnace().getQuantity(this.oreItem(), this.barItem()) >= 28;
        boolean barDispenserFull = furnaceHasMetalBar && furnaceHasGoldBar || furnaceHasGoldOre && furnaceHasGoldBar || fullOfMetalBarsAndOres;
        boolean bl = needToCollectBars = barDispenserFull || !tickPerfectMethod && furnaceHasBar;
        if (state.getBank().isOpen()) {
            if (needToCollectBars) {
                if (state.getInventory().has(this.oreItem(), 444, this.barItem(), 2357)) {
                    return useDepositInventory ? this.depositInventory : this.depositBarsAndOres;
                }
                this.lastInvWasGold = true;
                return this.collectBars;
            }
            if (state.getCoalBag().isFull() && state.getInventory().has(this.oreItem(), 444)) {
                return this.putOntoConveyorBelt;
            }
            if (state.getInventory().has(2357, this.barItem())) {
                return useDepositInventory ? this.depositInventory : this.depositBarsAndOres;
            }
            if (!useDepositInventory && !coalBagFull) {
                return coalBagEmpty ? this.fillCoalBag : this.refillCoalBag;
            }
            if (!useDepositInventory && coalRun && !state.getEquipment().hasGoldsmithEffect()) {
                return this.equipGoldsmithGauntlets;
            }
            if (coalRun && !state.getInventory().has(this.oreItem(), 444)) {
                this.lastInvWasGold = true;
                return this.withdrawGoldOre;
            }
            if (!state.getInventory().has(this.oreItem(), 444)) {
                this.lastInvWasGold = false;
                return this.withdrawOre();
            }
            if (useDepositInventory && !coalBagFull) {
                return coalBagEmpty ? this.fillCoalBag : this.refillCoalBag;
            }
        }
        if (state.getInventory().has(444) && !state.getEquipment().hasGoldsmithEffect()) {
            return this.equipGoldsmithGauntlets;
        }
        if (!barDispenserFull && (state.getCoalBag().recentlyEmptiedCoalBag || state.getInventory().has(453, 444, this.oreItem()))) {
            state.getCoalBag().recentlyEmptiedCoalBag = false;
            return this.putOntoConveyorBelt;
        }
        if (!barDispenserFull && atConveyorBelt && (coalBagFull || !coalBagEmpty && smithingCapeEquipped)) {
            return this.emptyCoalBag;
        }
        if (barDispenserFull && state.getInventory().has(453) && !state.getCoalBag().isFull()) {
            return this.fillCoalBag;
        }
        if (needToCollectBars && state.getInventory().has(453, this.oreItem(), this.barItem(), 444)) {
            return state.getConfig().useDepositInventory() ? this.depositInventory : this.depositBarsAndOres;
        }
        if (tickPerfectMethod && (furnaceHasGoldBar && (oreOnConveyor || furnaceHasGoldOre || furnaceHasMetalOre) || furnaceHasMetalBar && (oreOnConveyor || furnaceHasGoldOre || fullOfMetalBarsAndOres || furnaceHasGoldBar))) {
            if (atConveyorBelt) {
                return this.goToDispenser;
            }
            if (furnaceHasGoldBar && (oreOnConveyor || furnaceHasGoldOre) && this.lastInvWasGold && state.getEquipment().hasIceGlovesEffect()) {
                return this.collectBarsAndEquipGoldsmithGauntlets;
            }
            if (oreOnConveyor && this.lastInvWasGold && furnaceHasMetalBar) {
                return this.waitForGoldBars;
            }
            if (!atBarDispenser) {
                return this.goToDispenserAndEquipIceOrSmithsGloves;
            }
            return this.collectBars;
        }
        if (!tickPerfectMethod && (oreOnConveyor || furnaceHasGoldOre || furnaceHasMetalOre)) {
            return this.waitForBars;
        }
        if (!tickPerfectMethod && furnaceHasBar) {
            if (!state.getEquipment().hasIceGlovesEffect()) {
                return this.equipIceOrSmithsGloves;
            }
            return this.collectBars;
        }
        return this.openBank;
    }
}

