/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.methods;

import com.toofifty.easyblastfurnace.methods.Method;
import com.toofifty.easyblastfurnace.state.BlastFurnaceState;
import com.toofifty.easyblastfurnace.steps.MethodStep;
import com.toofifty.easyblastfurnace.utils.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoldBarMethod
extends Method {
    private static final Logger log = LoggerFactory.getLogger(GoldBarMethod.class);

    private MethodStep[] checkPrerequisite(BlastFurnaceState state) {
        if (!state.getInventory().has(1580, 27031) && !state.getEquipment().hasIceGlovesEffect()) {
            return state.getBank().isOpen() ? this.withdrawIceOrSmithsGloves : this.openBank;
        }
        if (state.getBank().has(13280) && !state.getInventory().has(13280) && !state.getEquipment().equipped(13280)) {
            return state.getBank().isOpen() ? this.withdrawMaxCape : this.openBank;
        }
        if (state.getInventory().has(13280) && !state.getEquipment().equipped(13280)) {
            return this.equipMaxCape;
        }
        if (state.getBank().has(9795, 9796) && !state.getInventory().has(9795, 9796) && !state.getEquipment().equipped(9795, 9796, 13280)) {
            return state.getBank().isOpen() ? this.withdrawSmithingCape : this.openBank;
        }
        if (state.getInventory().has(9795, 9796) && !state.getEquipment().equipped(9795, 9796, 13280)) {
            return this.equipSmithingCape;
        }
        if (!state.getInventory().has(776) && !state.getEquipment().hasGoldsmithEffect()) {
            return state.getBank().isOpen() ? this.withdrawGoldsmithGauntlets : this.openBank;
        }
        return null;
    }

    @Override
    public MethodStep[] next(BlastFurnaceState state) {
        MethodStep[] prerequisite = this.checkPrerequisite(state);
        if (prerequisite != null) {
            return prerequisite;
        }
        boolean oreOnConveyor = state.getPlayer().hasOreOnConveyor();
        boolean furnaceHasBar = state.getFurnace().has(2357);
        boolean furnaceHasOre = state.getFurnace().has(444);
        boolean tickPerfectMethod = state.getConfig().tickPerfectMethod();
        boolean atBarDispenser = state.getPlayer().isAtBarDispenser();
        boolean atConveyorBelt = state.getPlayer().isAtConveyorBelt();
        boolean useDepositInventory = state.getConfig().useDepositInventory();
        if (state.getBank().isOpen()) {
            if (furnaceHasOre && furnaceHasBar || !tickPerfectMethod && furnaceHasBar) {
                if (state.getInventory().has(2357, 444)) {
                    return useDepositInventory ? this.depositInventory : this.depositBarsAndOres;
                }
                return this.collectBars;
            }
            if (state.getInventory().has(2357)) {
                return state.getConfig().useDepositInventory() ? this.depositInventory : this.depositBarsAndOres;
            }
            if (tickPerfectMethod && !state.getEquipment().hasGoldsmithEffect() && !state.getEquipment().hasIceGlovesEffect()) {
                return this.equipGoldsmithGauntlets;
            }
            if (!tickPerfectMethod && !state.getEquipment().hasGoldsmithEffect()) {
                return this.equipGoldsmithGauntlets;
            }
            if (!state.getInventory().has(444)) {
                return this.withdrawGoldOre;
            }
        }
        if (tickPerfectMethod && state.getInventory().has(444)) {
            if (furnaceHasBar) {
                return this.putOntoConveyorBelt;
            }
            return this.putOntoConveyorBeltAndEquipGoldsmithGauntlets;
        }
        if (tickPerfectMethod && (oreOnConveyor || furnaceHasOre) && furnaceHasBar) {
            if (atConveyorBelt) {
                return this.goToDispenser;
            }
            if (!atBarDispenser) {
                return this.goToDispenserAndEquipIceOrSmithsGloves;
            }
            return this.collectBarsAndEquipGoldsmithGauntlets;
        }
        if (!tickPerfectMethod && state.getInventory().has(444)) {
            if (!state.getEquipment().hasGoldsmithEffect()) {
                return this.equipGoldsmithGauntlets;
            }
            return this.putOntoConveyorBelt;
        }
        if (!tickPerfectMethod && (oreOnConveyor || furnaceHasOre)) {
            return this.waitForGoldBars;
        }
        if (!tickPerfectMethod && furnaceHasBar) {
            if (!state.getEquipment().hasIceGlovesEffect()) {
                return this.equipIceOrSmithsGloves;
            }
            return this.collectBars;
        }
        return this.openBank;
    }

    @Override
    public String getName() {
        return Strings.GOLD;
    }
}

