/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.methods;

import com.toofifty.easyblastfurnace.methods.Method;
import com.toofifty.easyblastfurnace.state.BlastFurnaceState;
import com.toofifty.easyblastfurnace.steps.BankItemStep;
import com.toofifty.easyblastfurnace.steps.ItemStep;
import com.toofifty.easyblastfurnace.steps.MethodStep;
import com.toofifty.easyblastfurnace.utils.Strings;

public class DrinkPotionMethod
extends Method {
    private final MethodStep[] withdrawStaminaPotion1 = new MethodStep[]{new BankItemStep(Strings.WITHDRAW_STAMINA_POTION, 12631)};
    private final MethodStep[] withdrawStaminaPotion2 = new MethodStep[]{new BankItemStep(Strings.WITHDRAW_STAMINA_POTION, 12629)};
    private final MethodStep[] withdrawStaminaPotion3 = new MethodStep[]{new BankItemStep(Strings.WITHDRAW_STAMINA_POTION, 12627)};
    private final MethodStep[] withdrawStaminaPotion4 = new MethodStep[]{new BankItemStep(Strings.WITHDRAW_STAMINA_POTION, 12625)};
    private final MethodStep[] drinkStaminaPotion1 = new MethodStep[]{new ItemStep(Strings.DRINK_STAMINA_POTION, 12631)};
    private final MethodStep[] drinkStaminaPotion2 = new MethodStep[]{new ItemStep(Strings.DRINK_STAMINA_POTION, 12629)};
    private final MethodStep[] drinkStaminaPotion3 = new MethodStep[]{new ItemStep(Strings.DRINK_STAMINA_POTION, 12627)};
    private final MethodStep[] drinkStaminaPotion4 = new MethodStep[]{new ItemStep(Strings.DRINK_STAMINA_POTION, 12625)};
    private final MethodStep[] getMoreStaminaPotions = new MethodStep[]{new ItemStep(Strings.GET_MORE_STAMINA_POTIONS, 12019)};
    private final MethodStep[] withdrawSuperEnergyPotion1 = new MethodStep[]{new BankItemStep(Strings.WITHDRAW_SUPER_ENERGY_POTION, 3022)};
    private final MethodStep[] withdrawSuperEnergyPotion2 = new MethodStep[]{new BankItemStep(Strings.WITHDRAW_SUPER_ENERGY_POTION, 3020)};
    private final MethodStep[] withdrawSuperEnergyPotion3 = new MethodStep[]{new BankItemStep(Strings.WITHDRAW_SUPER_ENERGY_POTION, 3018)};
    private final MethodStep[] withdrawSuperEnergyPotion4 = new MethodStep[]{new BankItemStep(Strings.WITHDRAW_SUPER_ENERGY_POTION, 3016)};
    private final MethodStep[] drinkSuperEnergyPotion1 = new MethodStep[]{new ItemStep(Strings.DRINK_SUPER_ENERGY_POTION, 3022)};
    private final MethodStep[] drinkSuperEnergyPotion2 = new MethodStep[]{new ItemStep(Strings.DRINK_SUPER_ENERGY_POTION, 3020)};
    private final MethodStep[] drinkSuperEnergyPotion3 = new MethodStep[]{new ItemStep(Strings.DRINK_SUPER_ENERGY_POTION, 3018)};
    private final MethodStep[] drinkSuperEnergyPotion4 = new MethodStep[]{new ItemStep(Strings.DRINK_SUPER_ENERGY_POTION, 3016)};
    private final MethodStep[] getMoreSuperEnergyPotions = new MethodStep[]{new ItemStep(Strings.GET_MORE_SUPER_ENERGY_POTIONS, 12019)};
    private final MethodStep[] withdrawEnergyPotion1 = new MethodStep[]{new BankItemStep(Strings.WITHDRAW_ENERGY_POTION, 3014)};
    private final MethodStep[] withdrawEnergyPotion2 = new MethodStep[]{new BankItemStep(Strings.WITHDRAW_ENERGY_POTION, 3012)};
    private final MethodStep[] withdrawEnergyPotion3 = new MethodStep[]{new BankItemStep(Strings.WITHDRAW_ENERGY_POTION, 3010)};
    private final MethodStep[] withdrawEnergyPotion4 = new MethodStep[]{new BankItemStep(Strings.WITHDRAW_ENERGY_POTION, 3008)};
    private final MethodStep[] drinkEnergyPotion1 = new MethodStep[]{new ItemStep(Strings.DRINK_ENERGY_POTION, 3014)};
    private final MethodStep[] drinkEnergyPotion2 = new MethodStep[]{new ItemStep(Strings.DRINK_ENERGY_POTION, 3012)};
    private final MethodStep[] drinkEnergyPotion3 = new MethodStep[]{new ItemStep(Strings.DRINK_ENERGY_POTION, 3010)};
    private final MethodStep[] drinkEnergyPotion4 = new MethodStep[]{new ItemStep(Strings.DRINK_ENERGY_POTION, 3008)};
    private final MethodStep[] getMoreEnergyPotions = new MethodStep[]{new ItemStep(Strings.GET_MORE_ENERGY_POTIONS, 12019)};

    @Override
    public MethodStep[] next(BlastFurnaceState state) {
        switch (state.getConfig().potionOverlayMode()) {
            case SUPER_ENERGY: {
                return this.GetSuperEnergyStep(state);
            }
            case ENERGY: {
                return this.GetEnergyStep(state);
            }
        }
        return this.GetStaminaStep(state);
    }

    private MethodStep[] GetStaminaStep(BlastFurnaceState state) {
        if (state.getPlayer().hasEnoughEnergy() && state.getInventory().has(229, 12631, 12629, 12627, 12625)) {
            return state.getConfig().useDepositInventory() ? this.depositInventory : this.depositStaminaPotions;
        }
        if (!state.getBank().isOpen() || state.getPlayer().hasEnoughEnergy()) {
            return null;
        }
        if (!state.getInventory().has(12631, 12629, 12627, 12625) && !state.getInventory().hasFreeSlots()) {
            return state.getConfig().useDepositInventory() ? this.depositInventory : this.depositBarsAndOres;
        }
        if (state.getInventory().has(12631)) {
            return this.drinkStaminaPotion1;
        }
        if (state.getInventory().has(12629)) {
            return this.drinkStaminaPotion2;
        }
        if (state.getInventory().has(12627)) {
            return this.drinkStaminaPotion3;
        }
        if (state.getInventory().has(12625)) {
            return this.drinkStaminaPotion4;
        }
        if (state.getBank().has(12631)) {
            return this.withdrawStaminaPotion1;
        }
        if (state.getBank().has(12629)) {
            return this.withdrawStaminaPotion2;
        }
        if (state.getBank().has(12627)) {
            return this.withdrawStaminaPotion3;
        }
        if (state.getBank().has(12625)) {
            return this.withdrawStaminaPotion4;
        }
        return this.getMoreStaminaPotions;
    }

    private MethodStep[] GetSuperEnergyStep(BlastFurnaceState state) {
        if (state.getPlayer().hasEnoughEnergy() && state.getInventory().has(229, 3022, 3020, 3018, 3016)) {
            return state.getConfig().useDepositInventory() ? this.depositInventory : this.depositSuperEnergyPotions;
        }
        if (!state.getBank().isOpen() || state.getPlayer().hasEnoughEnergy()) {
            return null;
        }
        if (!state.getInventory().has(3022, 3020, 3018, 3016) && !state.getInventory().hasFreeSlots()) {
            return state.getConfig().useDepositInventory() ? this.depositInventory : this.depositBarsAndOres;
        }
        if (state.getInventory().has(3016)) {
            return this.drinkSuperEnergyPotion4;
        }
        if (state.getInventory().has(3018)) {
            return this.drinkSuperEnergyPotion3;
        }
        if (state.getInventory().has(3020)) {
            return this.drinkSuperEnergyPotion2;
        }
        if (state.getInventory().has(3022)) {
            return this.drinkSuperEnergyPotion1;
        }
        if (state.getBank().has(3022)) {
            return this.withdrawSuperEnergyPotion1;
        }
        if (state.getBank().has(3020)) {
            return this.withdrawSuperEnergyPotion2;
        }
        if (state.getBank().has(3018)) {
            return this.withdrawSuperEnergyPotion3;
        }
        if (state.getBank().has(3016)) {
            return this.withdrawSuperEnergyPotion4;
        }
        return this.getMoreSuperEnergyPotions;
    }

    private MethodStep[] GetEnergyStep(BlastFurnaceState state) {
        if (state.getPlayer().hasEnoughEnergy() && state.getInventory().has(229, 3014, 3012, 3010, 3008)) {
            return state.getConfig().useDepositInventory() ? this.depositInventory : this.depositEnergyPotions;
        }
        if (!state.getBank().isOpen() || state.getPlayer().hasEnoughEnergy()) {
            return null;
        }
        if (!state.getInventory().has(3014, 3012, 3010, 3008) && !state.getInventory().hasFreeSlots()) {
            return state.getConfig().useDepositInventory() ? this.depositInventory : this.depositBarsAndOres;
        }
        if (state.getInventory().has(3008)) {
            return this.drinkEnergyPotion4;
        }
        if (state.getInventory().has(3010)) {
            return this.drinkEnergyPotion3;
        }
        if (state.getInventory().has(3012)) {
            return this.drinkEnergyPotion2;
        }
        if (state.getInventory().has(3014)) {
            return this.drinkEnergyPotion1;
        }
        if (state.getBank().has(3014)) {
            return this.withdrawEnergyPotion1;
        }
        if (state.getBank().has(3012)) {
            return this.withdrawEnergyPotion2;
        }
        if (state.getBank().has(3010)) {
            return this.withdrawEnergyPotion3;
        }
        if (state.getBank().has(3008)) {
            return this.withdrawEnergyPotion4;
        }
        return this.getMoreEnergyPotions;
    }

    @Override
    public String getName() {
        return Strings.DRINK_STAMINA;
    }
}

