/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.toofifty.easyblastfurnace.EasyBlastFurnaceConfig;
import com.toofifty.easyblastfurnace.overlays.BankItemStepOverlay;
import com.toofifty.easyblastfurnace.overlays.CoalBagOverlay;
import com.toofifty.easyblastfurnace.overlays.InstructionOverlay;
import com.toofifty.easyblastfurnace.overlays.ItemStepOverlay;
import com.toofifty.easyblastfurnace.overlays.ObjectStepOverlay;
import com.toofifty.easyblastfurnace.overlays.StatisticsOverlay;
import com.toofifty.easyblastfurnace.overlays.TileStepOverlay;
import com.toofifty.easyblastfurnace.overlays.WidgetStepOverlay;
import com.toofifty.easyblastfurnace.state.BlastFurnaceState;
import com.toofifty.easyblastfurnace.utils.MethodHandler;
import com.toofifty.easyblastfurnace.utils.ObjectManager;
import com.toofifty.easyblastfurnace.utils.SessionStatistics;
import com.toofifty.easyblastfurnace.utils.Strings;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Easy Blast Furnace", description="Helps you train at the blast furnace more efficiently")
public class EasyBlastFurnacePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EasyBlastFurnacePlugin.class);
    public static final int CONVEYOR_BELT = 9100;
    public static final int BAR_DISPENSER = 9092;
    public static final int BANK_CHEST = 26707;
    public static final WorldPoint PICKUP_POSITION = new WorldPoint(1940, 4962, 0);
    private static final Pattern COAL_FULL_MESSAGE = Pattern.compile(Strings.COAL_FULL);
    private static final Pattern COAL_EMPTY_MESSAGE = Pattern.compile(Strings.COAL_EMPTY);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private EasyBlastFurnaceConfig config;
    @Inject
    private BlastFurnaceState state;
    @Inject
    private ObjectManager objectManager;
    @Inject
    private InstructionOverlay instructionOverlay;
    @Inject
    private StatisticsOverlay statisticsOverlay;
    @Inject
    private ItemStepOverlay itemStepOverlay;
    @Inject
    private BankItemStepOverlay bankItemStepOverlay;
    @Inject
    private WidgetStepOverlay widgetStepOverlay;
    @Inject
    private ObjectStepOverlay objectStepOverlay;
    @Inject
    private TileStepOverlay tileStepOverlay;
    @Inject
    private CoalBagOverlay coalBagOverlay;
    @Inject
    private MethodHandler methodHandler;
    @Inject
    private SessionStatistics statistics;
    private boolean isEnabled = false;
    private int lastCheckTick = 0;
    private int oreOntoConveyorCount = 0;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.instructionOverlay);
        this.overlayManager.add((Overlay)this.statisticsOverlay);
        this.overlayManager.add((Overlay)this.coalBagOverlay);
        this.overlayManager.add((Overlay)this.itemStepOverlay);
        this.overlayManager.add((Overlay)this.bankItemStepOverlay);
        this.overlayManager.add((Overlay)this.widgetStepOverlay);
        this.overlayManager.add((Overlay)this.objectStepOverlay);
        this.overlayManager.add((Overlay)this.tileStepOverlay);
    }

    protected void shutDown() {
        this.statistics.clear();
        this.methodHandler.clear();
        this.overlayManager.remove((Overlay)this.instructionOverlay);
        this.overlayManager.remove((Overlay)this.statisticsOverlay);
        this.overlayManager.remove((Overlay)this.coalBagOverlay);
        this.overlayManager.remove((Overlay)this.itemStepOverlay);
        this.overlayManager.remove((Overlay)this.bankItemStepOverlay);
        this.overlayManager.remove((Overlay)this.widgetStepOverlay);
        this.overlayManager.remove((Overlay)this.objectStepOverlay);
        this.overlayManager.remove((Overlay)this.tileStepOverlay);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        switch (gameObject.getId()) {
            case 26707: {
                this.objectManager.add(gameObject);
                break;
            }
            case 9092: 
            case 9100: {
                this.objectManager.add(gameObject);
                this.isEnabled = true;
            }
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject gameObject = event.getGameObject();
        switch (gameObject.getId()) {
            case 9092: 
            case 9100: {
                if (this.config.clearMethodOnExit()) {
                    this.methodHandler.clear();
                }
                if (this.config.clearStatisticsOnExit()) {
                    this.statistics.clear();
                }
                this.isEnabled = false;
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGGED_IN) {
            if (this.config.clearMethodOnLogout()) {
                this.methodHandler.clear();
            }
            if (this.config.clearStatisticsOnLogout()) {
                this.statistics.clear();
            }
            this.isEnabled = false;
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (!this.isEnabled) {
            return;
        }
        if (event.getContainerId() == InventoryID.INVENTORY.getId()) {
            this.methodHandler.setMethodFromInventory();
            this.state.update();
        }
        this.methodHandler.next();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (!this.isEnabled) {
            return;
        }
        this.statistics.onFurnaceUpdate();
        this.state.update();
        this.methodHandler.next();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (Objects.equals(event.getGroup(), "easy-blastfurnace") && Objects.equals(event.getKey(), "potionMode")) {
            this.clientThread.invokeLater(() -> this.methodHandler.next());
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (!this.isEnabled) {
            return;
        }
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String message = event.getMessage();
        int maxConveyorCount = this.state.getCoalBag().getMaxCoal() == 27 ? 2 : 3;
        Matcher emptyMatcher = COAL_EMPTY_MESSAGE.matcher(message);
        Matcher filledMatcher = COAL_FULL_MESSAGE.matcher(message);
        if (emptyMatcher.matches()) {
            this.state.getCoalBag().empty();
        }
        if (filledMatcher.matches()) {
            int addedCoal = Integer.parseInt(filledMatcher.group(1));
            this.state.getCoalBag().setCoal(this.state.getCoalBag().getCoal() + addedCoal);
        }
        if (message.equals("All your ore goes onto the conveyor belt.")) {
            this.oreOntoConveyorCount = this.state.getInventory().has(453) ? ++this.oreOntoConveyorCount : 1;
        }
        if (maxConveyorCount == this.oreOntoConveyorCount) {
            this.oreOntoConveyorCount = 0;
            if (this.state.getCoalBag().getCoal() > 1) {
                this.state.getCoalBag().setCoal(0);
            }
        }
        this.methodHandler.next();
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        int currentTick;
        if (!this.isEnabled) {
            return;
        }
        if (event.getMenuOption().equals(Strings.DRINK)) {
            this.statistics.drinkStamina();
        }
        if (this.lastCheckTick == (currentTick = this.client.getTickCount())) {
            return;
        }
        this.lastCheckTick = currentTick;
        if (event.getMenuOption().equals(Strings.EMPTY)) {
            this.state.getCoalBag().empty();
        }
        this.methodHandler.next();
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked event) {
        if (event.getOverlay() == this.instructionOverlay && event.getEntry().getOption().equals("Reset")) {
            this.methodHandler.clear();
        }
        if (event.getOverlay() == this.statisticsOverlay && event.getEntry().getOption().equals("Clear")) {
            this.statistics.clear();
        }
    }

    @Provides
    EasyBlastFurnaceConfig provideConfig(ConfigManager configManager) {
        return (EasyBlastFurnaceConfig)configManager.getConfig(EasyBlastFurnaceConfig.class);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public int getLastCheckTick() {
        return this.lastCheckTick;
    }
}

