/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace;

import com.toofifty.easyblastfurnace.config.HighlightOverlayTextSetting;
import com.toofifty.easyblastfurnace.config.ItemOverlaySetting;
import com.toofifty.easyblastfurnace.config.PotionOverlaySetting;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Units;

@ConfigGroup(value="easy-blastfurnace")
public interface EasyBlastFurnaceConfig
extends Config {
    @ConfigSection(name="Guidance overlays", description="Configure instruction, item and object overlays", position=0)
    public static final String guidanceOverlays = "guidanceOverlays";
    @ConfigSection(name="Coal bag overlay", description="Configure coal bag overlay", position=1)
    public static final String coalBagOverlay = "coalBagOverlay";
    @ConfigSection(name="Stamina potions", description="Configure stamina potions", position=2)
    public static final String staminaPotions = "staminaPotions";
    @ConfigSection(name="Statistics overlay", description="Configure statistics overlay", position=3)
    public static final String statisticsOverlay = "statisticsOverlay";
    @ConfigSection(name="Cleanup", description="Configure auto-clearing plugin state", position=4, closedByDefault=true)
    public static final String cleanup = "cleanup";

    @ConfigItem(position=0, keyName="showStepOverlay", name="Show step overlay", description="Show an instructional overlay of the next step", section="guidanceOverlays")
    default public boolean showStepOverlay() {
        return true;
    }

    @ConfigItem(position=1, keyName="itemOverlayMode", name="Item overlay mode", description="Select how highlighted items appear", section="guidanceOverlays")
    default public ItemOverlaySetting itemOverlayMode() {
        return ItemOverlaySetting.BOX;
    }

    @ConfigItem(position=2, keyName="itemOverlayTextMode", name="Item overlay tooltip", description="Select where to display tooltip text for items", section="guidanceOverlays")
    default public HighlightOverlayTextSetting itemOverlayTextMode() {
        return HighlightOverlayTextSetting.BELOW;
    }

    @ConfigItem(position=3, keyName="itemOverlayColor", name="Item overlay color", description="Change the color of the item overlay", section="guidanceOverlays")
    default public Color itemOverlayColor() {
        return Color.CYAN;
    }

    @ConfigItem(position=4, keyName="showObjectOverlays", name="Show object overlays", description="Enables clickbox overlays for the next object to click", section="guidanceOverlays")
    default public boolean showObjectOverlays() {
        return true;
    }

    @ConfigItem(position=5, keyName="useDepositInventory", name="Use deposit inventory button", description="When enabled, the deposit inventory button will be highlighted instead of individual items in your inventory during bank deposits.", section="guidanceOverlays")
    default public boolean useDepositInventory() {
        return false;
    }

    @ConfigItem(position=6, keyName="objectOverlayTextMode", name="Object overlay tooltip", description="Select where to display tooltip text for game objects", section="guidanceOverlays")
    default public HighlightOverlayTextSetting objectOverlayTextMode() {
        return HighlightOverlayTextSetting.ABOVE;
    }

    @ConfigItem(position=7, keyName="objectOverlayColor", name="Object overlay color", description="Change the color of the object overlay", section="guidanceOverlays")
    default public Color objectOverlayColor() {
        return Color.CYAN;
    }

    @ConfigItem(position=8, keyName="leaveBarInDispenser", name="Toggle tick perfect methods", description="Enable tick perfect gold method and efficient metal/gold hybrid methods.", section="guidanceOverlays")
    default public boolean tickPerfectMethod() {
        return false;
    }

    @ConfigItem(position=0, keyName="showCoalBagOverlay", name="Show coal bag overlay", description="Display the amount of coal inside your coal bag", section="coalBagOverlay")
    default public boolean showCoalBagOverlay() {
        return true;
    }

    @ConfigItem(position=1, keyName="coalBagOverlayColor", name="Coal bag overlay color", description="Change the color of the coal bag count", section="coalBagOverlay")
    default public Color coalBagOverlayColor() {
        return Color.CYAN;
    }

    @ConfigItem(position=0, keyName="staminaPotionEnable", name="Stamina potion management", description="Allow the plugin to handle stamina potions.", section="staminaPotions")
    default public boolean staminaPotionEnable() {
        return true;
    }

    @ConfigItem(position=1, keyName="potionMode", name="Potion Highlight", description="Select the potion to highlight", section="staminaPotions")
    default public PotionOverlaySetting potionOverlayMode() {
        return PotionOverlaySetting.STAMINA;
    }

    @ConfigItem(position=2, keyName="requireStaminaThreshold", name="Low energy threshold", description="Run energy will be kept above this value. 0 - 50% recommended.", section="staminaPotions")
    @Units(value="%")
    default public int requireStaminaThreshold() {
        return 30;
    }

    @ConfigItem(position=0, keyName="showStatisticsOverlay", name="Show statistics", description="Show an overlay with statistics such as bars todo/done, XP banked & stamina doses used.", section="statisticsOverlay")
    default public boolean showStatisticsOverlay() {
        return true;
    }

    @ConfigItem(position=1, keyName="showBarsTodo", name="Show bars todo", description="Show amount of bars that can be made from ores in the bank.", section="statisticsOverlay")
    default public boolean showBarsTodo() {
        return true;
    }

    @ConfigItem(position=2, keyName="showBarsMade", name="Show bars made", description="Show amount of bars made in the session.", section="statisticsOverlay")
    default public boolean showBarsMade() {
        return true;
    }

    @ConfigItem(position=3, keyName="showBarsPerHour", name="Show bars/hr", description="Show amount of bars made per hour.", section="statisticsOverlay")
    default public boolean showBarsPerHour() {
        return true;
    }

    @ConfigItem(position=4, keyName="showXpBanked", name="Show XP banked", description="Show amount of Smithing XP that can be gained from ores in the bank.", section="statisticsOverlay")
    default public boolean showXpBanked() {
        return true;
    }

    @ConfigItem(position=5, keyName="showXpGained", name="Show XP gained", description="Show amount of Smithing XP gained in the session.", section="statisticsOverlay")
    default public boolean showXpGained() {
        return true;
    }

    @ConfigItem(position=6, keyName="showStaminaDoses", name="Show stamina doses", description="Show amount of stamina potion doses consumed in the session.", section="statisticsOverlay")
    default public boolean showStaminaDoses() {
        return true;
    }

    @ConfigItem(position=0, keyName="clearMethodOnLogout", name="Clear method on logout", description="Clear the current method on logout. If disabled, the method can still be cleared by (shift) right clicking the overlay.", section="cleanup")
    default public boolean clearMethodOnLogout() {
        return true;
    }

    @ConfigItem(position=1, keyName="clearMethodOnExit", name="Clear method on BF exit", description="Clear the current method when exiting the Blast Furnace. If disabled, the method can still be cleared by (shift) right clicking the overlay.", section="cleanup")
    default public boolean clearMethodOnExit() {
        return true;
    }

    @ConfigItem(position=2, keyName="clearStatisticsOnLogout", name="Clear stats on logout", description="Clear the statistics on logout. If disabled, the statistics can still be cleared by (shift) right clicking the overlay.", section="cleanup")
    default public boolean clearStatisticsOnLogout() {
        return true;
    }

    @ConfigItem(position=3, keyName="clearStatisticsOnExit", name="Clear stats on BF exit", description="Clear the statistics when exiting the Blast Furnace. If disabled, the statistics can still be cleared by (shift) right clicking the overlay.", section="cleanup")
    default public boolean clearStatisticsOnExit() {
        return true;
    }

    @ConfigItem(position=5, keyName="addCoalBuffer", name="Add coal buffer", description="Ensure there is always more coal than needed in the furnace. This avoids stalls while bars are created.")
    default public boolean addCoalBuffer() {
        return false;
    }
}

