/*
 * Decompiled with CFR 0.152.
 */
package com.github.m0bilebtw;

import com.github.m0bilebtw.SkillBarWidgetGrouping;
import com.github.m0bilebtw.SkillData;
import com.github.m0bilebtw.SkillsTabProgressBarsConfig;
import com.google.inject.Provides;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.GameState;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.JavaScriptCallback;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Skills Progress Bars", description="Adds progress bars to the skills tab to show how close the next level ups are", tags={"skills", "stats", "levels", "goals", "progress", "bars"})
public class SkillsTabProgressBarsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SkillsTabProgressBarsPlugin.class);
    private static final int SCRIPTID_STATS_INIT = 393;
    private static final int SCRIPTID_STATS_SKILLTOTAL = 396;
    static final int MINIMUM_BAR_HEIGHT = 1;
    static final int MAXIMUM_BAR_HEIGHT = 32;
    private static final int INDENT_WIDTH_ONE_SIDE = 4;
    private static final int WIDGET_CHILD_ID_MASK = 65535;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private SkillsTabProgressBarsConfig config;
    private Widget currentWidget;
    private SkillBarWidgetGrouping currentHovered;
    private SkillBarWidgetGrouping[] skillBars = new SkillBarWidgetGrouping[SkillData.values().length];
    private float[] progressStartHSB;
    private float[] progressEndHSB;
    private float[] goalStartHSB;
    private float[] goalEndHSB;

    protected void startUp() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invoke(this::buildSkillBars);
        }
    }

    protected void shutDown() {
        this.clientThread.invoke(this::removeSkillBars);
    }

    @Provides
    SkillsTabProgressBarsConfig provideConfig(ConfigManager configManager) {
        return (SkillsTabProgressBarsConfig)configManager.getConfig(SkillsTabProgressBarsConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("skillstabprogressbars".equals(event.getGroup())) {
            switch (event.getKey()) {
                case "progressBarStartColor": {
                    this.progressStartHSB = null;
                    break;
                }
                case "progressBarEndColor": {
                    this.progressEndHSB = null;
                    break;
                }
                case "goalBarStartColor": {
                    this.goalStartHSB = null;
                    break;
                }
                case "goalBarEndColor": {
                    this.goalEndHSB = null;
                    break;
                }
                case "showOnHover": {
                    this.handleContainerListener();
                }
            }
            this.updateSkillBars();
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        if (event.getScriptId() != 393) {
            return;
        }
        this.currentWidget = event.getScriptEvent().getSource();
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 393 && this.currentWidget != null) {
            this.buildSkillBar(this.currentWidget);
        } else if (event.getScriptId() == 396) {
            this.handleContainerListener();
        }
    }

    private void buildSkillBars() {
        Widget skillsContainer = this.client.getWidget(0x1400000);
        if (skillsContainer == null) {
            return;
        }
        for (Widget skillTile : skillsContainer.getStaticChildren()) {
            this.buildSkillBar(skillTile);
        }
        this.handleContainerListener();
    }

    private void removeSkillBars() {
        for (SkillBarWidgetGrouping grouping : this.skillBars) {
            if (grouping == null) continue;
            Widget parent = grouping.getBarBackground().getParent();
            this.removeHoverListener(parent, grouping);
            Widget[] children = parent.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Widget child = children[i];
                if (!grouping.contains(child)) continue;
                children[i] = null;
            }
        }
        this.removeContainerListener();
        this.skillBars = new SkillBarWidgetGrouping[SkillData.values().length];
    }

    private int getChildId(int id) {
        return id & 0xFFFF;
    }

    private void buildSkillBar(Widget parent) {
        int idx = this.getChildId(parent.getId()) - 1;
        SkillData skill = SkillData.get(idx);
        if (skill == null) {
            return;
        }
        Widget grayOut99 = parent.createChild(-1, 3);
        grayOut99.setXPositionMode(1);
        grayOut99.setYPositionMode(1);
        grayOut99.setWidthMode(1);
        grayOut99.setHeightMode(1);
        grayOut99.setOriginalWidth(0);
        grayOut99.setOriginalHeight(0);
        grayOut99.setFilled(true);
        grayOut99.setHasListener(true);
        grayOut99.setTextColor(Color.BLACK.getRGB());
        Widget barBackground = parent.createChild(-1, 3);
        barBackground.setYPositionMode(2);
        barBackground.setWidthMode(1);
        barBackground.setFilled(true);
        barBackground.setHasListener(true);
        Widget barForeground = parent.createChild(-1, 3);
        barForeground.setYPositionMode(2);
        barForeground.setFilled(true);
        barForeground.setHasListener(true);
        Widget goalBackground = parent.createChild(-1, 3);
        goalBackground.setYPositionMode(2);
        goalBackground.setWidthMode(1);
        goalBackground.setFilled(true);
        goalBackground.setHasListener(true);
        Widget goalForeground = parent.createChild(-1, 3);
        goalForeground.setYPositionMode(2);
        goalForeground.setFilled(true);
        goalForeground.setHasListener(true);
        SkillBarWidgetGrouping grouping = new SkillBarWidgetGrouping(grayOut99, barBackground, barForeground, goalBackground, goalForeground);
        JavaScriptCallback updateCallback = ev -> this.updateSkillBar(skill, grouping);
        grayOut99.setOnVarTransmitListener(new Object[]{updateCallback});
        barBackground.setOnVarTransmitListener(new Object[]{updateCallback});
        barForeground.setOnVarTransmitListener(new Object[]{updateCallback});
        goalBackground.setOnVarTransmitListener(new Object[]{updateCallback});
        goalForeground.setOnVarTransmitListener(new Object[]{updateCallback});
        this.updateSkillBar(skill, grouping);
        this.handleHoverListener(parent, grouping);
        this.skillBars[idx] = grouping;
    }

    private void handleHoverListener(Widget parent, SkillBarWidgetGrouping grouping) {
        if (this.config.showOnHover()) {
            this.addHoverListener(parent, grouping);
        } else {
            this.removeHoverListener(parent, grouping);
        }
    }

    private void addHoverListener(Widget parent, SkillBarWidgetGrouping grouping) {
        Widget grayOut99 = grouping.getGrayOut99();
        Widget barBackground = grouping.getBarBackground();
        Widget barForeground = grouping.getBarForeground();
        Widget goalBackground = grouping.getGoalBackground();
        Widget goalForeground = grouping.getGoalForeground();
        grayOut99.setHidden(true);
        barBackground.setHidden(true);
        barForeground.setHidden(true);
        goalBackground.setHidden(true);
        goalForeground.setHidden(true);
        parent.setOnMouseOverListener(new Object[]{ev -> {
            if (this.currentHovered != null) {
                this.currentHovered.getGrayOut99().setHidden(true);
                this.currentHovered.getBarBackground().setHidden(true);
                this.currentHovered.getBarForeground().setHidden(true);
                this.currentHovered.getGoalBackground().setHidden(true);
                this.currentHovered.getGoalForeground().setHidden(true);
            }
            this.currentHovered = grouping;
            grayOut99.setHidden(false);
            barBackground.setHidden(false);
            barForeground.setHidden(false);
            goalBackground.setHidden(false);
            goalForeground.setHidden(false);
        }});
        parent.setHasListener(true);
    }

    private void removeHoverListener(Widget parent, SkillBarWidgetGrouping grouping) {
        Widget grayOut99 = grouping.getGrayOut99();
        Widget barBackground = grouping.getBarBackground();
        Widget barForeground = grouping.getBarForeground();
        Widget goalBackground = grouping.getGoalBackground();
        Widget goalForeground = grouping.getGoalForeground();
        grayOut99.setHidden(false);
        barBackground.setHidden(false);
        barForeground.setHidden(false);
        goalBackground.setHidden(false);
        goalForeground.setHidden(false);
        parent.setOnMouseOverListener((Object[])null);
    }

    private void handleContainerListener() {
        if (this.config.showOnHover()) {
            this.addContainerListener();
        } else {
            this.removeContainerListener();
        }
    }

    private void addContainerListener() {
        Widget container = this.client.getWidget(0x1400000);
        if (container == null) {
            return;
        }
        container.setOnMouseLeaveListener(new Object[]{ev -> {
            if (this.currentHovered != null) {
                this.currentHovered.getGrayOut99().setHidden(true);
                this.currentHovered.getBarBackground().setHidden(true);
                this.currentHovered.getBarForeground().setHidden(true);
                this.currentHovered.getGoalBackground().setHidden(true);
                this.currentHovered.getGoalForeground().setHidden(true);
            }
            this.currentHovered = null;
        }});
        container.setHasListener(true);
    }

    private void removeContainerListener() {
        Widget container = this.client.getWidget(0x1400000);
        if (container == null) {
            return;
        }
        container.setOnMouseLeaveListener((Object[])null);
    }

    private void updateSkillBars() {
        this.clientThread.invoke(() -> {
            for (int i = 0; i < SkillData.values().length; ++i) {
                SkillData skill = SkillData.get(i);
                SkillBarWidgetGrouping widgets = this.skillBars[i];
                if (widgets == null) continue;
                this.updateSkillBar(skill, widgets);
                this.handleHoverListener(widgets.getBarBackground().getParent(), widgets);
            }
        });
    }

    private void updateSkillBar(SkillData skill, SkillBarWidgetGrouping grouping) {
        Widget grayOut99 = grouping.getGrayOut99();
        Widget barBackground = grouping.getBarBackground();
        Widget barForeground = grouping.getBarForeground();
        Widget goalBackground = grouping.getGoalBackground();
        Widget goalForeground = grouping.getGoalForeground();
        int currentXP = this.client.getSkillExperience(skill.getSkill());
        int currentLevel = Experience.getLevelForXp((int)currentXP);
        int currentLevelXP = Experience.getXpForLevel((int)currentLevel);
        int nextLevelXP = currentLevel >= 126 ? 200000000 : Experience.getXpForLevel((int)(currentLevel + 1));
        int goalStartXP = this.client.getVarpValue(skill.getGoalStartVarp());
        int goalEndXP = this.client.getVarpValue(skill.getGoalEndVarp());
        double barPercent = Math.min(1.0, (double)(currentXP - currentLevelXP) / (double)(nextLevelXP - currentLevelXP));
        double goalPercent = Math.min(1.0, (double)(currentXP - goalStartXP) / (double)(goalEndXP - goalStartXP));
        int startX = this.config.indent() ? 4 : 0;
        int maxWidth = barForeground.getParent().getOriginalWidth();
        if (this.config.indent()) {
            maxWidth -= 8;
        }
        boolean shouldGrayOut = this.config.grayOut99() && currentLevel >= 99 || this.config.grayOut200m() && currentLevelXP >= 200000000;
        boolean shouldCalculateNormalBar = !this.config.showOnlyGoals() && (currentLevel < 99 || this.config.virtualLevels()) && currentLevelXP < 200000000;
        boolean shouldCalculateGoalBar = goalEndXP > 0 && this.config.showGoals();
        boolean shouldRenderAnyBars = !this.config.showOnHover() || grouping == this.currentHovered;
        int barHeight = this.config.barHeight();
        if (barHeight > 16 && shouldCalculateNormalBar && shouldCalculateGoalBar) {
            barHeight /= 2;
        }
        if (shouldGrayOut) {
            grayOut99.setOpacity(255 - this.config.grayOutOpacity());
        } else {
            grayOut99.setOpacity(255);
        }
        if (shouldCalculateNormalBar) {
            barBackground.setHidden(!shouldRenderAnyBars);
            barForeground.setHidden(!shouldRenderAnyBars);
            barBackground.setOriginalX(startX);
            barBackground.setOriginalY(0);
            barBackground.setOriginalWidth(this.config.indent() ? 8 : 0);
            barBackground.setOriginalHeight(barHeight);
            barBackground.setTextColor(this.config.backgroundColor().getRGB());
            barBackground.setOpacity(255 - this.config.backgroundColor().getAlpha());
            int progressWidth = (int)((double)maxWidth * barPercent);
            barForeground.setOriginalX(startX);
            barForeground.setOriginalY(0);
            barForeground.setOriginalWidth(progressWidth);
            barForeground.setOriginalHeight(barHeight);
            barForeground.setTextColor(this.lerpHSB(this.getProgressStartHSB(), this.getProgressEndHSB(), barPercent));
            barForeground.setOpacity(255 - this.lerpAlpha(this.config.progressBarStartColor(), this.config.progressBarEndColor(), barPercent));
        } else {
            barBackground.setOpacity(255);
            barForeground.setOpacity(255);
        }
        if (shouldCalculateGoalBar) {
            int yPos = barHeight * (shouldCalculateNormalBar ? 1 : 0);
            goalBackground.setHidden(!shouldRenderAnyBars);
            goalForeground.setHidden(!shouldRenderAnyBars);
            goalBackground.setOriginalX(startX);
            goalBackground.setOriginalY(yPos);
            goalBackground.setOriginalWidth(this.config.indent() ? 8 : 0);
            goalBackground.setOriginalHeight(barHeight);
            goalBackground.setTextColor(this.config.backgroundColor().getRGB());
            goalBackground.setOpacity(255 - this.config.backgroundColor().getAlpha());
            int goalWidth = (int)((double)maxWidth * goalPercent);
            goalForeground.setOriginalX(startX);
            goalForeground.setOriginalY(yPos);
            goalForeground.setOriginalWidth(goalWidth);
            goalForeground.setOriginalHeight(barHeight);
            goalForeground.setTextColor(this.lerpHSB(this.getGoalStartHSB(), this.getGoalEndHSB(), goalPercent));
            goalForeground.setOpacity(255 - this.lerpAlpha(this.config.goalBarStartColor(), this.config.goalBarEndColor(), goalPercent));
        } else {
            goalBackground.setOpacity(255);
            goalForeground.setOpacity(255);
        }
        grayOut99.revalidate();
        barBackground.revalidate();
        barForeground.revalidate();
        goalBackground.revalidate();
        goalForeground.revalidate();
    }

    private int lerpHSB(float[] start, float[] end, double percent) {
        return Color.getHSBColor((float)((double)start[0] + percent * (double)(end[0] - start[0])), (float)((double)start[1] + percent * (double)(end[1] - start[1])), (float)((double)start[2] + percent * (double)(end[2] - start[2]))).getRGB();
    }

    private int lerpAlpha(Color start, Color end, double percent) {
        return (int)Math.round((double)start.getAlpha() + percent * (double)(end.getAlpha() - start.getAlpha()));
    }

    private float[] getProgressStartHSB() {
        if (this.progressStartHSB == null) {
            this.progressStartHSB = this.getHSBArray(this.config.progressBarStartColor());
        }
        return this.progressStartHSB;
    }

    private float[] getProgressEndHSB() {
        if (this.progressEndHSB == null) {
            this.progressEndHSB = this.getHSBArray(this.config.progressBarEndColor());
        }
        return this.progressEndHSB;
    }

    private float[] getGoalStartHSB() {
        if (this.goalStartHSB == null) {
            this.goalStartHSB = this.getHSBArray(this.config.goalBarStartColor());
        }
        return this.goalStartHSB;
    }

    private float[] getGoalEndHSB() {
        if (this.goalEndHSB == null) {
            this.goalEndHSB = this.getHSBArray(this.config.goalBarEndColor());
        }
        return this.goalEndHSB;
    }

    private float[] getHSBArray(Color color) {
        float[] arr = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), arr);
        return arr;
    }
}

