/*
 * Decompiled with CFR 0.152.
 */
package com.volcanicmine;

import com.google.inject.Provides;
import com.volcanicmine.VMConfig;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Volcanic Mine", description="Useful timers for when to start moving in Volcanic Mine", tags={"volcanic", "mine", "vm", "mining", "timer", "warning"})
public class VMPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(VMPlugin.class);
    private static final String CHAT_VM_START = "The volcano awakens! You can now access the area below...";
    private static final String PLATFORM_WARNING_MESSAGE = "The platform beneath you will disappear soon!";
    private static final String BOULDER_WARNING_MESSAGE = "The current boulder stage is complete.";
    private static final int PLATFORM_STAGE_3_ID = 31000;
    private static final int BOULDER_BREAK_STAGE_1_ID = 7807;
    private static final int BOULDER_BREAK_STAGE_2_ID = 7809;
    private static final int BOULDER_BREAK_STAGE_3_ID = 7811;
    private static final int BOULDER_BREAK_STAGE_4_ID = 7813;
    private static final int BOULDER_BREAK_STAGE_5_ID = 7815;
    private static final int VM_REGION_NORTH = 15263;
    private static final int VM_REGION_SOUTH = 15262;
    private static final Duration VM_FULL_TIME = Duration.ofMinutes(10L);
    private static final Duration VM_HALF_TIME = Duration.ofMinutes(5L);
    @Inject
    private Notifier notifier;
    @Inject
    private Client client;
    @Inject
    private VMConfig config;
    private Duration timeUntilVentWarning;
    private Duration timeUntilEruptionWarning;
    private Instant VMTimer;
    private boolean hasWarnedVent = false;
    private boolean hasWarnedEruption = false;

    @Provides
    VMConfig getConfig(ConfigManager configManager) {
        return (VMConfig)configManager.getConfig(VMConfig.class);
    }

    private void reset() {
        this.VMTimer = null;
        this.hasWarnedVent = false;
        this.hasWarnedEruption = false;
    }

    private void calcVentWarningTime() {
        if (this.config.showVentWarning()) {
            this.timeUntilVentWarning = VM_HALF_TIME.minusSeconds(this.config.ventWarningTime());
        }
    }

    private void calcEruptionWarningTime() {
        if (this.config.showEruptionWarning()) {
            this.timeUntilEruptionWarning = VM_FULL_TIME.minusSeconds(this.config.eruptionWarningTime());
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("volcanicmine") || event.getKey().equals("showPlatformWarning")) {
            return;
        }
        this.calcVentWarningTime();
        this.calcEruptionWarningTime();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.timeUntilVentWarning = VM_HALF_TIME.minusSeconds(this.config.ventWarningTime());
            this.timeUntilEruptionWarning = VM_FULL_TIME.minusSeconds(this.config.eruptionWarningTime());
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String chatMsg = Text.removeTags((String)event.getMessage());
        if (chatMsg.equals(CHAT_VM_START)) {
            this.VMTimer = Instant.now();
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.VMTimer != null) {
            if (!this.isInVM()) {
                this.reset();
                return;
            }
            Duration timeSinceStart = Duration.between(this.VMTimer, Instant.now());
            if (timeSinceStart.compareTo(this.timeUntilVentWarning) >= 0 && !this.hasWarnedVent && this.config.showVentWarning()) {
                this.notifier.notify("The vents will shift in " + this.config.ventWarningTime() + " seconds!");
                this.hasWarnedVent = true;
            }
            if (timeSinceStart.compareTo(this.timeUntilEruptionWarning) >= 0 && !this.hasWarnedEruption && this.config.showEruptionWarning()) {
                this.notifier.notify("The volcano will erupt in " + this.config.eruptionWarningTime() + " seconds!");
                this.hasWarnedEruption = true;
            }
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (!this.isInVM()) {
            return;
        }
        if (this.config.showPlatformWarning() && event.getGameObject().getId() == 31000) {
            int playerX = this.client.getLocalPlayer().getWorldLocation().getX();
            int playerY = this.client.getLocalPlayer().getWorldLocation().getY();
            int objectX = event.getGameObject().getWorldLocation().getX();
            int objectY = event.getGameObject().getWorldLocation().getY();
            if (playerX == objectX && playerY == objectY) {
                this.notifier.notify(PLATFORM_WARNING_MESSAGE);
            }
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        if (!this.isInVM()) {
            return;
        }
        if (this.config.showBoulderWarning()) {
            NPC npc = npcSpawned.getNpc();
            switch (npc.getId()) {
                case 7807: 
                case 7809: 
                case 7811: 
                case 7813: 
                case 7815: {
                    this.notifier.notify(BOULDER_WARNING_MESSAGE);
                    break;
                }
            }
        }
    }

    private boolean isInVM() {
        return WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID() == 15263 || WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID() == 15262;
    }
}

