/*
 * Decompiled with CFR 0.152.
 */
package com.volcanicmine;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="volcanicmine")
public interface VMConfig
extends Config {
    @ConfigItem(keyName="ventWarning", name="Vent Shift Notification", description="Show warning in advance of vents resetting 5 minutes into game", position=0)
    default public boolean showVentWarning() {
        return true;
    }

    @ConfigItem(keyName="ventWarningTime", name="Vent Shift Warning Time", description="Number of seconds before the vents reset", position=1)
    @Range(max=60, min=1)
    @Units(value="s")
    default public int ventWarningTime() {
        return 25;
    }

    @ConfigItem(keyName="eruptionWarning", name="Eruption Notification", description="Show warning in advance of the volcano erupting", position=2)
    default public boolean showEruptionWarning() {
        return true;
    }

    @ConfigItem(keyName="eruptionWarningTime", name="Eruption Warning Time", description="Number of seconds before the volcano erupts", position=3)
    @Range(max=60, min=30)
    @Units(value="s")
    default public int eruptionWarningTime() {
        return 40;
    }

    @ConfigItem(keyName="platformWarning", name="Platform Despawn Notification", description="Show warning for when platform below you is about to disappear", position=4)
    default public boolean showPlatformWarning() {
        return true;
    }

    @ConfigItem(keyName="boulderMovement", name="Boulder Movement Notification", description="Notify when current boulder stage is complete", position=5)
    default public boolean showBoulderWarning() {
        return false;
    }
}

