/*
 * Decompiled with CFR 0.152.
 */
package net.machpi.runelite.influxdb.write;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;

public final class Series {
    private final String measurement;
    private final Map<@NonNull String, @NonNull String> tags;

    Series(String measurement, Map<@NonNull String, @NonNull String> tags) {
        this.measurement = measurement;
        this.tags = tags;
    }

    public static SeriesBuilder builder() {
        return new SeriesBuilder();
    }

    public String getMeasurement() {
        return this.measurement;
    }

    public Map<@NonNull String, @NonNull String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Series)) {
            return false;
        }
        Series other = (Series)o;
        String this$measurement = this.getMeasurement();
        String other$measurement = other.getMeasurement();
        if (this$measurement == null ? other$measurement != null : !this$measurement.equals(other$measurement)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $measurement = this.getMeasurement();
        result = result * 59 + ($measurement == null ? 43 : $measurement.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "Series(measurement=" + this.getMeasurement() + ", tags=" + this.getTags() + ")";
    }

    public static class SeriesBuilder {
        private String measurement;
        private ArrayList<@NonNull String> tags$key;
        private ArrayList<@NonNull String> tags$value;

        SeriesBuilder() {
        }

        public SeriesBuilder measurement(String measurement) {
            this.measurement = measurement;
            return this;
        }

        public SeriesBuilder tag(@NonNull String tagKey, @NonNull String tagValue) {
            if (tagKey == null) {
                throw new NullPointerException("tagKey is marked non-null but is null");
            }
            if (tagValue == null) {
                throw new NullPointerException("tagValue is marked non-null but is null");
            }
            if (this.tags$key == null) {
                this.tags$key = new ArrayList();
                this.tags$value = new ArrayList();
            }
            this.tags$key.add(tagKey);
            this.tags$value.add(tagValue);
            return this;
        }

        public SeriesBuilder tags(Map<? extends @NonNull String, ? extends @NonNull String> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags$key == null) {
                this.tags$key = new ArrayList();
                this.tags$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : tags.entrySet()) {
                this.tags$key.add($lombokEntry.getKey());
                this.tags$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SeriesBuilder clearTags() {
            if (this.tags$key != null) {
                this.tags$key.clear();
                this.tags$value.clear();
            }
            return this;
        }

        public Series build() {
            Map<String, String> tags;
            switch (this.tags$key == null ? 0 : this.tags$key.size()) {
                case 0: {
                    tags = Collections.emptyMap();
                    break;
                }
                case 1: {
                    tags = Collections.singletonMap(this.tags$key.get(0), this.tags$value.get(0));
                    break;
                }
                default: {
                    tags = new LinkedHashMap<String, String>(this.tags$key.size() < 0x40000000 ? 1 + this.tags$key.size() + (this.tags$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.tags$key.size(); ++$i) {
                        tags.put(this.tags$key.get($i), this.tags$value.get($i));
                    }
                    tags = Collections.unmodifiableMap(tags);
                }
            }
            return new Series(this.measurement, tags);
        }

        public String toString() {
            return "Series.SeriesBuilder(measurement=" + this.measurement + ", tags$key=" + this.tags$key + ", tags$value=" + this.tags$value + ")";
        }
    }
}

