/*
 * Decompiled with CFR 0.152.
 */
package net.machpi.runelite.influxdb.write;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import net.machpi.runelite.influxdb.write.Series;
import org.influxdb.dto.Point;

public final class Measurement {
    private final Series series;
    private final long time;
    private final Map<@NonNull String, @NonNull String> stringValues;
    private final Map<@NonNull String, @NonNull Number> numericValues;

    Optional<Point> toInflux() {
        if (this.getStringValues().isEmpty() && this.getNumericValues().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Point.measurement(this.series.getMeasurement()).tag(this.series.getTags()).time(this.time, TimeUnit.MILLISECONDS).fields(this.getStringValues()).fields(this.getNumericValues()).build());
    }

    private static long $default$time() {
        return System.currentTimeMillis();
    }

    Measurement(Series series, long time, Map<@NonNull String, @NonNull String> stringValues, Map<@NonNull String, @NonNull Number> numericValues) {
        this.series = series;
        this.time = time;
        this.stringValues = stringValues;
        this.numericValues = numericValues;
    }

    public static MeasurementBuilder builder() {
        return new MeasurementBuilder();
    }

    public Series getSeries() {
        return this.series;
    }

    public long getTime() {
        return this.time;
    }

    public Map<@NonNull String, @NonNull String> getStringValues() {
        return this.stringValues;
    }

    public Map<@NonNull String, @NonNull Number> getNumericValues() {
        return this.numericValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Measurement)) {
            return false;
        }
        Measurement other = (Measurement)o;
        if (this.getTime() != other.getTime()) {
            return false;
        }
        Series this$series = this.getSeries();
        Series other$series = other.getSeries();
        if (this$series == null ? other$series != null : !((Object)this$series).equals(other$series)) {
            return false;
        }
        Map<String, String> this$stringValues = this.getStringValues();
        Map<String, String> other$stringValues = other.getStringValues();
        if (this$stringValues == null ? other$stringValues != null : !((Object)this$stringValues).equals(other$stringValues)) {
            return false;
        }
        Map<String, Number> this$numericValues = this.getNumericValues();
        Map<String, Number> other$numericValues = other.getNumericValues();
        return !(this$numericValues == null ? other$numericValues != null : !((Object)this$numericValues).equals(other$numericValues));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        Series $series = this.getSeries();
        result = result * 59 + ($series == null ? 43 : ((Object)$series).hashCode());
        Map<String, String> $stringValues = this.getStringValues();
        result = result * 59 + ($stringValues == null ? 43 : ((Object)$stringValues).hashCode());
        Map<String, Number> $numericValues = this.getNumericValues();
        result = result * 59 + ($numericValues == null ? 43 : ((Object)$numericValues).hashCode());
        return result;
    }

    public String toString() {
        return "Measurement(series=" + this.getSeries() + ", time=" + this.getTime() + ", stringValues=" + this.getStringValues() + ", numericValues=" + this.getNumericValues() + ")";
    }

    public static class MeasurementBuilder {
        private Series series;
        private boolean time$set;
        private long time$value;
        private ArrayList<@NonNull String> stringValues$key;
        private ArrayList<@NonNull String> stringValues$value;
        private ArrayList<@NonNull String> numericValues$key;
        private ArrayList<@NonNull Number> numericValues$value;

        MeasurementBuilder() {
        }

        public MeasurementBuilder series(Series series) {
            this.series = series;
            return this;
        }

        public MeasurementBuilder time(long time) {
            this.time$value = time;
            this.time$set = true;
            return this;
        }

        public MeasurementBuilder stringValue(@NonNull String stringValueKey, @NonNull String stringValueValue) {
            if (stringValueKey == null) {
                throw new NullPointerException("stringValueKey is marked non-null but is null");
            }
            if (stringValueValue == null) {
                throw new NullPointerException("stringValueValue is marked non-null but is null");
            }
            if (this.stringValues$key == null) {
                this.stringValues$key = new ArrayList();
                this.stringValues$value = new ArrayList();
            }
            this.stringValues$key.add(stringValueKey);
            this.stringValues$value.add(stringValueValue);
            return this;
        }

        public MeasurementBuilder stringValues(Map<? extends @NonNull String, ? extends @NonNull String> stringValues) {
            if (stringValues == null) {
                throw new NullPointerException("stringValues cannot be null");
            }
            if (this.stringValues$key == null) {
                this.stringValues$key = new ArrayList();
                this.stringValues$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : stringValues.entrySet()) {
                this.stringValues$key.add($lombokEntry.getKey());
                this.stringValues$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public MeasurementBuilder clearStringValues() {
            if (this.stringValues$key != null) {
                this.stringValues$key.clear();
                this.stringValues$value.clear();
            }
            return this;
        }

        public MeasurementBuilder numericValue(@NonNull String numericValueKey, @NonNull Number numericValueValue) {
            if (numericValueKey == null) {
                throw new NullPointerException("numericValueKey is marked non-null but is null");
            }
            if (numericValueValue == null) {
                throw new NullPointerException("numericValueValue is marked non-null but is null");
            }
            if (this.numericValues$key == null) {
                this.numericValues$key = new ArrayList();
                this.numericValues$value = new ArrayList();
            }
            this.numericValues$key.add(numericValueKey);
            this.numericValues$value.add(numericValueValue);
            return this;
        }

        public MeasurementBuilder numericValues(Map<? extends @NonNull String, ? extends @NonNull Number> numericValues) {
            if (numericValues == null) {
                throw new NullPointerException("numericValues cannot be null");
            }
            if (this.numericValues$key == null) {
                this.numericValues$key = new ArrayList();
                this.numericValues$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Number> $lombokEntry : numericValues.entrySet()) {
                this.numericValues$key.add($lombokEntry.getKey());
                this.numericValues$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public MeasurementBuilder clearNumericValues() {
            if (this.numericValues$key != null) {
                this.numericValues$key.clear();
                this.numericValues$value.clear();
            }
            return this;
        }

        public Measurement build() {
            Map<String, Number> numericValues;
            Map<String, String> stringValues;
            switch (this.stringValues$key == null ? 0 : this.stringValues$key.size()) {
                case 0: {
                    stringValues = Collections.emptyMap();
                    break;
                }
                case 1: {
                    stringValues = Collections.singletonMap(this.stringValues$key.get(0), this.stringValues$value.get(0));
                    break;
                }
                default: {
                    stringValues = new LinkedHashMap(this.stringValues$key.size() < 0x40000000 ? 1 + this.stringValues$key.size() + (this.stringValues$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.stringValues$key.size(); ++$i) {
                        stringValues.put(this.stringValues$key.get($i), this.stringValues$value.get($i));
                    }
                    stringValues = Collections.unmodifiableMap(stringValues);
                }
            }
            switch (this.numericValues$key == null ? 0 : this.numericValues$key.size()) {
                case 0: {
                    numericValues = Collections.emptyMap();
                    break;
                }
                case 1: {
                    numericValues = Collections.singletonMap(this.numericValues$key.get(0), this.numericValues$value.get(0));
                    break;
                }
                default: {
                    numericValues = new LinkedHashMap(this.numericValues$key.size() < 0x40000000 ? 1 + this.numericValues$key.size() + (this.numericValues$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.numericValues$key.size(); ++$i) {
                        numericValues.put(this.numericValues$key.get($i), this.numericValues$value.get($i));
                    }
                    numericValues = Collections.unmodifiableMap(numericValues);
                }
            }
            long time$value = this.time$value;
            if (!this.time$set) {
                time$value = Measurement.$default$time();
            }
            return new Measurement(this.series, time$value, stringValues, numericValues);
        }

        public String toString() {
            return "Measurement.MeasurementBuilder(series=" + this.series + ", time$value=" + this.time$value + ", stringValues$key=" + this.stringValues$key + ", stringValues$value=" + this.stringValues$value + ", numericValues$key=" + this.numericValues$key + ", numericValues$value=" + this.numericValues$value + ")";
        }
    }
}

