/*
 * Decompiled with CFR 0.152.
 */
package net.machpi.runelite.influxdb.activity;

import com.google.common.collect.ComparisonChain;
import java.time.Duration;
import java.time.Instant;
import java.util.EnumMap;
import java.util.Optional;
import java.util.TreeSet;
import javax.inject.Inject;
import net.machpi.runelite.influxdb.InfluxDbConfig;
import net.machpi.runelite.influxdb.MeasurementCreator;
import net.machpi.runelite.influxdb.activity.GameEvent;
import net.machpi.runelite.influxdb.write.Measurement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityState {
    private static final Logger log = LoggerFactory.getLogger(ActivityState.class);
    private final InfluxDbConfig config;
    private final MeasurementCreator measurer;
    private final EnumMap<GameEvent, EventWithTime> latestEvents = new EnumMap(GameEvent.class);
    private final TreeSet<EventWithTime> events;

    @Inject
    public ActivityState(InfluxDbConfig config, MeasurementCreator measurer) {
        this.config = config;
        this.measurer = measurer;
        this.events = new TreeSet((a, b) -> ComparisonChain.start().compare(b.getType().getPriority(), a.getType().getPriority()).compare(b.getUpdated(), a.getUpdated()).result());
    }

    public void reset() {
        this.events.clear();
        this.latestEvents.clear();
    }

    public void triggerEvent(GameEvent eventType) {
        if (!this.config.writeActivity()) {
            return;
        }
        EventWithTime event = this.latestEvents.get((Object)eventType);
        if (event == null) {
            event = new EventWithTime(eventType, Instant.now());
            this.latestEvents.put(eventType, event);
        } else {
            this.events.remove(event);
        }
        event.setUpdated(Instant.now());
        this.events.add(event);
        if (event.getType().isShouldClear()) {
            this.events.removeIf(e -> {
                boolean remove;
                boolean bl = remove = e.getType() != eventType && e.getType().isShouldClear();
                if (remove) {
                    this.latestEvents.remove((Object)e.getType());
                }
                return remove;
            });
        }
    }

    public State getState() {
        if (this.events.isEmpty() || !this.config.writeActivity()) {
            return null;
        }
        Duration activityTimeout = Duration.ofMinutes(this.config.activityTimeout());
        Instant now = Instant.now();
        EventWithTime eventWithTime = this.events.first();
        if (GameEvent.IN_MENU.getLocation().equals(eventWithTime.getType().getLocation()) && now.isAfter(eventWithTime.getStart().plus(activityTimeout))) {
            return null;
        }
        String location = null;
        String skill = null;
        String locationType = null;
        for (EventWithTime e : this.events) {
            if (skill == null && e.getType().getSkill() != null) {
                skill = e.getType().getSkill().name();
            }
            if (location == null) {
                location = e.getType().getLocation();
            }
            if (locationType == null && e.getType().getLocationType() != null) {
                locationType = e.getType().getLocationType().name();
            }
            if (skill == null || location == null || locationType == null) continue;
            break;
        }
        return new State(skill, location, locationType);
    }

    public void checkForTimeout() {
        if (this.events.isEmpty() || !this.config.writeActivity()) {
            return;
        }
        Duration activityTimeout = Duration.ofMinutes(this.config.activityTimeout());
        Instant now = Instant.now();
        this.events.removeIf(event -> {
            boolean remove;
            boolean bl = remove = event.getType().isShouldTimeout() && now.isAfter(event.getUpdated().plus(activityTimeout));
            if (remove) {
                this.latestEvents.remove((Object)event.getType());
            }
            return remove;
        });
    }

    public Optional<Measurement> measure() {
        if (!this.config.writeActivity()) {
            return Optional.empty();
        }
        State state = this.getState();
        if (state == null) {
            return Optional.empty();
        }
        return this.measurer.createActivityMeasurement(state);
    }

    public static class State {
        private final String skill;
        private final String location;
        private final String locationType;

        public State(String skill, String location, String locationType) {
            this.skill = skill;
            this.location = location;
            this.locationType = locationType;
        }

        public String getSkill() {
            return this.skill;
        }

        public String getLocation() {
            return this.location;
        }

        public String getLocationType() {
            return this.locationType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State other = (State)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$skill = this.getSkill();
            String other$skill = other.getSkill();
            if (this$skill == null ? other$skill != null : !this$skill.equals(other$skill)) {
                return false;
            }
            String this$location = this.getLocation();
            String other$location = other.getLocation();
            if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
                return false;
            }
            String this$locationType = this.getLocationType();
            String other$locationType = other.getLocationType();
            return !(this$locationType == null ? other$locationType != null : !this$locationType.equals(other$locationType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof State;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $skill = this.getSkill();
            result = result * 59 + ($skill == null ? 43 : $skill.hashCode());
            String $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : $location.hashCode());
            String $locationType = this.getLocationType();
            result = result * 59 + ($locationType == null ? 43 : $locationType.hashCode());
            return result;
        }

        public String toString() {
            return "ActivityState.State(skill=" + this.getSkill() + ", location=" + this.getLocation() + ", locationType=" + this.getLocationType() + ")";
        }
    }

    private static class EventWithTime {
        private final GameEvent type;
        private final Instant start;
        private Instant updated;

        public EventWithTime(GameEvent type, Instant start) {
            this.type = type;
            this.start = start;
        }

        public GameEvent getType() {
            return this.type;
        }

        public Instant getStart() {
            return this.start;
        }

        public Instant getUpdated() {
            return this.updated;
        }

        public void setUpdated(Instant updated) {
            this.updated = updated;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventWithTime)) {
                return false;
            }
            EventWithTime other = (EventWithTime)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GameEvent this$type = this.getType();
            GameEvent other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Instant this$start = this.getStart();
            Instant other$start = other.getStart();
            if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
                return false;
            }
            Instant this$updated = this.getUpdated();
            Instant other$updated = other.getUpdated();
            return !(this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EventWithTime;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GameEvent $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Instant $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
            Instant $updated = this.getUpdated();
            result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
            return result;
        }

        public String toString() {
            return "ActivityState.EventWithTime(type=" + this.getType() + ", start=" + this.getStart() + ", updated=" + this.getUpdated() + ")";
        }
    }
}

