/*
 * Decompiled with CFR 0.152.
 */
package net.machpi.runelite.influxdb;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Set;
import net.machpi.runelite.influxdb.MeasurementCreator;
import net.machpi.runelite.influxdb.write.InfluxWriter;
import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class SkillingItemTracker {
    private static final Logger log = LoggerFactory.getLogger(SkillingItemTracker.class);
    private static final Set<Integer> IGNORED_ITEMS = ImmutableSet.of(Integer.valueOf(995), Integer.valueOf(1831), Integer.valueOf(1829), Integer.valueOf(1827), Integer.valueOf(1825), Integer.valueOf(1823), new Integer[]{2313, 1887, 1931, 1923, 13400, 8792, 314});
    private static final Set<Skill> VALID_SKILLS = ImmutableSet.of(Skill.RUNECRAFT, Skill.CRAFTING, Skill.MINING, Skill.SMITHING, Skill.FIREMAKING, Skill.COOKING, new Skill[]{Skill.WOODCUTTING, Skill.HERBLORE, Skill.HUNTER, Skill.FLETCHING, Skill.FARMING, Skill.FISHING});
    private final Client client;
    private final ItemManager itemManager;
    private final MeasurementCreator measurementCreator;
    private final InfluxWriter writer;
    private Multiset<Integer> prevInventoryItems = HashMultiset.create();
    private Multiset<Integer> currInventoryItems = HashMultiset.create();
    private int trackingDataForTick = -1;
    private final Multiset<Integer> currTickAddedItems = HashMultiset.create();
    private final Multiset<Skill> currTickXp = HashMultiset.create();

    @Inject
    public SkillingItemTracker(Client client, ItemManager itemManager, MeasurementCreator measurementCreator, InfluxWriter writer) {
        this.client = client;
        this.itemManager = itemManager;
        this.measurementCreator = measurementCreator;
        this.writer = writer;
    }

    public void onInventoryChanges(ItemContainer container) {
        for (int i = 0; i < container.size(); ++i) {
            int id;
            Item item = container.getItem(i);
            if (item == null || IGNORED_ITEMS.contains(id = this.itemManager.canonicalize(item.getId()))) continue;
            this.currInventoryItems.add(id, item.getQuantity());
        }
        for (Multiset.Entry<Integer> entry : this.currInventoryItems.entrySet()) {
            int prevCount = this.prevInventoryItems.count(entry.getElement());
            int newItems = entry.getCount() - prevCount;
            if (newItems <= 0) continue;
            this.onItemAdded(entry.getElement(), newItems);
        }
        Multiset<Integer> tmp = this.prevInventoryItems;
        this.prevInventoryItems = this.currInventoryItems;
        this.currInventoryItems = tmp;
        tmp.clear();
    }

    public void onXpGained(Skill skill, int xp) {
        if (VALID_SKILLS.contains(skill)) {
            this.flushIfNeeded();
            this.currTickXp.add(skill, xp);
        }
    }

    private void onItemAdded(int id, int count) {
        this.flushIfNeeded();
        this.currTickAddedItems.add(id, count);
    }

    public void flushIfNeeded() {
        int tick = this.client.getTickCount();
        if (this.trackingDataForTick == tick) {
            return;
        }
        if (this.currTickXp.entrySet().size() == 1) {
            Multiset.Entry<Skill> skill = Iterables.getOnlyElement(this.currTickXp.entrySet());
            float weightedXp = (float)skill.getCount() / (float)this.currTickAddedItems.size();
            for (Multiset.Entry<Integer> item : this.currTickAddedItems.entrySet()) {
                ItemComposition composition = this.itemManager.getItemComposition(item.getElement().intValue());
                this.writer.submit(this.measurementCreator.createSkillingItemMeasurement(skill.getElement(), skill.getCount(), weightedXp, composition, item.getCount()));
            }
        }
        this.currTickAddedItems.clear();
        this.currTickXp.clear();
        this.trackingDataForTick = tick;
    }
}

