/*
 * Decompiled with CFR 0.152.
 */
package net.machpi.runelite.influxdb;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Singleton;
import net.machpi.runelite.influxdb.AchievementDiary;
import net.machpi.runelite.influxdb.CombatAchievement;
import net.machpi.runelite.influxdb.InventoryID2;
import net.machpi.runelite.influxdb.WorldTags;
import net.machpi.runelite.influxdb.activity.ActivityState;
import net.machpi.runelite.influxdb.activity.GameEvent;
import net.machpi.runelite.influxdb.write.Measurement;
import net.machpi.runelite.influxdb.write.Series;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.WorldType;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.http.api.loottracker.LootRecordType;

@Singleton
public class MeasurementCreator {
    public static final String SERIES_INVENTORY = "rs_inventory";
    public static final String SERIES_SKILL = "rs_skill";
    public static final String SERIES_SELF = "rs_self";
    public static final String SERIES_ACHIEVEMENTS = "rs_achievements";
    public static final String SERIES_KILL_COUNT = "rs_killcount";
    public static final String SERIES_SELF_LOC = "rs_self_loc";
    public static final String SERIES_ACTIVITY = "rs_activity";
    public static final String SERIES_LOOT = "rs_loot";
    public static final String SERIES_SKILLING_ITEMS = "rs_skilling_items";
    public static final String SELF_KEY_X = "locX";
    public static final String SELF_KEY_Y = "locY";
    public static final Set<String> SELF_POS_KEYS = ImmutableSet.of("locX", "locY");
    private final Client client;
    private final ItemManager itemManager;
    private final ConfigManager configManager;
    private static final int VARBIT_LEAGUE_TASKS = 10046;
    private static final int VARP_LEAGUE_POINTS = 2614;
    private static final int VARP_COLLECTION_LOG_ACHIEVED = 2943;
    private static final int VARP_COLLECTION_LOG_TOTAL = 2944;
    private static final Pattern SENTENCE_CASE_PATTERN = Pattern.compile("( |^)([a-z])");
    static final String KILL_COUNT_CFG_GROUP = "killcount";
    static final String PERSONAL_BEST_CFG_GROUP = "personalbest";
    private static final int THRESHOLD = 50000;

    @Inject
    public MeasurementCreator(Client client, ItemManager itemManager, ConfigManager configManager) {
        this.client = client;
        this.itemManager = itemManager;
        this.configManager = configManager;
    }

    public boolean isInLastManStanding() {
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null) {
            return false;
        }
        int regionId = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPlayer.getLocalLocation()).getRegionID();
        return GameEvent.MG_LAST_MAN_STANDING.equals((Object)GameEvent.fromRegion(regionId));
    }

    private Series.SeriesBuilder createSeries() {
        String userName;
        String playerName;
        Series.SeriesBuilder builder = Series.builder();
        builder.tag("account", Long.toString(this.client.getAccountHash()));
        Player player = this.client.getLocalPlayer();
        String string = playerName = player != null ? player.getName() : null;
        if (!Strings.isNullOrEmpty(playerName)) {
            builder.tag("player", playerName);
        }
        if (!Strings.isNullOrEmpty(userName = this.client.getUsername())) {
            builder.tag("user", userName);
        }
        builder.tags(WorldTags.tagsForWorld(this.client.getWorldType()));
        builder.tag("profile", this.configManager.getRSProfileKey());
        builder.tag("worldType", RuneScapeProfileType.getCurrent((Client)this.client).name());
        return builder;
    }

    public Series createXpSeries(Skill skill) {
        return this.createSeries().measurement(SERIES_SKILL).tag("skill", skill.name()).build();
    }

    public Optional<Measurement> createXpMeasurement(Skill skill) {
        int realLevel;
        int virtualLevel;
        long xp;
        long l = xp = skill == Skill.OVERALL ? this.client.getOverallExperience() : (long)this.client.getSkillExperience(skill);
        if (xp == 0L) {
            return Optional.empty();
        }
        if (skill == Skill.OVERALL) {
            virtualLevel = Arrays.stream(Skill.values()).filter(x -> x != Skill.OVERALL).mapToInt(x -> Experience.getLevelForXp((int)this.client.getSkillExperience(x))).sum();
            realLevel = this.client.getTotalLevel();
        } else {
            virtualLevel = Experience.getLevelForXp((int)((int)xp));
            realLevel = this.client.getRealSkillLevel(skill);
        }
        return Optional.of(Measurement.builder().series(this.createXpSeries(skill)).numericValue("xp", xp).numericValue("realLevel", realLevel).numericValue("virtualLevel", virtualLevel).build());
    }

    public Series createItemSeries(InventoryID2 inventory, InvValueType type) {
        return this.createSeries().measurement(SERIES_INVENTORY).tag("inventory", inventory.name()).tag("type", type.name()).build();
    }

    private static String itemToKey(ItemComposition composition) {
        return composition.getName() + "@" + composition.getId();
    }

    private static void addToMap(Map<String, Long> map, String key, long value) {
        map.compute(key, (_key, oldValue) -> (oldValue != null ? oldValue : 0L) + value);
    }

    public Stream<Measurement> createItemMeasurements(InventoryID2 inventoryID, Item[] items) {
        HashMap<String, Long> gePrice = new HashMap<String, Long>(items.length / 2);
        HashMap<String, Long> haPrice = new HashMap<String, Long>(items.length / 2);
        HashMap<String, Long> count = new HashMap<String, Long>(items.length / 2);
        long totalGe = 0L;
        long totalAlch = 0L;
        long otherGe = 0L;
        long otherAlch = 0L;
        for (Item item : items) {
            boolean highValue;
            long alch;
            long ge;
            if (item.getId() < 0 || item.getQuantity() <= 0 || item.getId() == 20594) continue;
            int canonId = this.itemManager.canonicalize(item.getId());
            ItemComposition data = this.itemManager.getItemComposition(canonId);
            switch (canonId) {
                case 995: {
                    ge = item.getQuantity();
                    alch = item.getQuantity();
                    break;
                }
                case 13204: {
                    ge = (long)item.getQuantity() * 1000L;
                    alch = (long)item.getQuantity() * 1000L;
                    break;
                }
                default: {
                    long storePrice = data.getPrice();
                    long alchPrice = (long)((float)storePrice * 0.6f);
                    alch = alchPrice * (long)item.getQuantity();
                    ge = (long)this.itemManager.getItemPrice(canonId) * (long)item.getQuantity();
                }
            }
            totalGe += ge;
            totalAlch += alch;
            boolean bl = highValue = ge > 50000L || alch > 50000L;
            if (highValue) {
                String key = MeasurementCreator.itemToKey(data);
                MeasurementCreator.addToMap(gePrice, key, ge);
                MeasurementCreator.addToMap(haPrice, key, alch);
                MeasurementCreator.addToMap(count, key, item.getQuantity());
                continue;
            }
            otherGe += ge;
            otherAlch += alch;
        }
        return Stream.of(Measurement.builder().series(this.createItemSeries(inventoryID, InvValueType.GE)).numericValues(gePrice).numericValue("total", totalGe).numericValue("other", otherGe).build(), Measurement.builder().series(this.createItemSeries(inventoryID, InvValueType.HA)).numericValues(haPrice).numericValue("total", totalAlch).numericValue("other", otherAlch).build(), Measurement.builder().series(this.createItemSeries(inventoryID, InvValueType.COUNT)).numericValues(count).build());
    }

    public Series createSelfLocSeries() {
        return this.createSeries().measurement(SERIES_SELF_LOC).build();
    }

    public Measurement createSelfLocMeasurement() {
        Player local = this.client.getLocalPlayer();
        WorldPoint location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local.getLocalLocation());
        return Measurement.builder().series(this.createSelfLocSeries()).numericValue(SELF_KEY_X, location.getX()).numericValue(SELF_KEY_Y, location.getY()).numericValue("plane", location.getPlane()).numericValue("instance", this.client.isInInstancedRegion() ? 1 : 0).build();
    }

    public Series createSelfSeries() {
        return this.createSeries().measurement(SERIES_SELF).build();
    }

    public Measurement createSelfMeasurement() {
        int combatAchievementsAchieved;
        int achievementDiaryAchieved;
        Player local = this.client.getLocalPlayer();
        Measurement.MeasurementBuilder builder = Measurement.builder().series(this.createSelfSeries()).numericValue("combat", Experience.getCombatLevelPrecise((int)this.client.getRealSkillLevel(Skill.ATTACK), (int)this.client.getRealSkillLevel(Skill.STRENGTH), (int)this.client.getRealSkillLevel(Skill.DEFENCE), (int)this.client.getRealSkillLevel(Skill.HITPOINTS), (int)this.client.getRealSkillLevel(Skill.MAGIC), (int)this.client.getRealSkillLevel(Skill.RANGED), (int)this.client.getRealSkillLevel(Skill.PRAYER))).numericValue("questPoints", this.client.getVarpValue(101)).numericValue("skulled", local.getSkullIcon() != null ? 1 : 0).stringValue("name", MoreObjects.firstNonNull(local.getName(), "none")).stringValue("overhead", local.getOverheadIcon() != null ? local.getOverheadIcon().name() : "NONE");
        if (this.client.getWorldType().contains(WorldType.SEASONAL) && WorldTags.League.findCurrentLeague() != null) {
            int tasksComplete = this.client.getVarbitValue(10046);
            int leaguePoints = this.client.getVarpValue(2614);
            builder.numericValue("leagueTasksComplete", tasksComplete).numericValue("leaguePoints", leaguePoints);
        }
        this.loadProfileConfig("slayer", "initialAmount", Integer::parseInt).ifPresent(amount -> builder.numericValue("slayerTaskAmount", (Number)amount));
        this.loadProfileConfig("slayer", "amount", Integer::parseInt).ifPresent(amount -> builder.numericValue("slayerTaskRemaining", (Number)amount));
        this.loadProfileConfig("slayer", "taskName", MeasurementCreator::toTitleCase).ifPresent(taskName -> {
            String taskLoc = this.loadProfileConfig("slayer", "taskLocation", MeasurementCreator::toTitleCase).orElse("Any Location");
            builder.stringValue("slayerTaskName", (String)taskName).stringValue("slayerTaskLoc", taskLoc);
        });
        this.loadProfileConfig("slayer", "points", Integer::parseInt).ifPresent(amount -> builder.numericValue("slayerPoints", (Number)amount));
        this.loadProfileConfig("slayer", "streak", Integer::parseInt).ifPresent(streak -> builder.numericValue("slayerTaskStreak", (Number)streak));
        int collectionLogAchieved = this.client.getVarpValue(2943);
        if (collectionLogAchieved > 0) {
            builder.numericValue("collectionLogAchieved", collectionLogAchieved);
        }
        if ((achievementDiaryAchieved = Arrays.stream(AchievementDiary.values()).mapToInt(d -> d.getTotal(this.client)).sum()) > 0) {
            builder.numericValue("achievementDiaryAchieved", achievementDiaryAchieved);
        }
        if ((combatAchievementsAchieved = Arrays.stream(CombatAchievement.values()).mapToInt(d -> d.getCompleted(this.client)).sum()) > 0) {
            builder.numericValue("combatAchievementsAchieved", combatAchievementsAchieved);
        }
        return builder.build();
    }

    public Series createAchievementSeries(String achievementGroup, String achievementTier) {
        return this.createSeries().measurement(SERIES_ACHIEVEMENTS).tag("group", achievementGroup).tag("tier", achievementTier).build();
    }

    private Optional<Measurement> createAchievementMeasurementInternal(String group, String tier, int count, int total) {
        if (count == 0 || total == 0) {
            return Optional.empty();
        }
        Measurement.MeasurementBuilder builder = Measurement.builder().series(this.createAchievementSeries(group, tier)).numericValue("count", count);
        if (total > 0) {
            builder.numericValue("total", total);
        }
        return Optional.of(builder.build());
    }

    public void createAchievementMeasurements(Consumer<Measurement> target) {
        for (AchievementDiary achievementDiary : AchievementDiary.values()) {
            this.createAchievementMeasurementInternal(achievementDiary.name(), "EASY", achievementDiary.getEasy(this.client), -1).ifPresent(target);
            this.createAchievementMeasurementInternal(achievementDiary.name(), "MEDIUM", achievementDiary.getMedium(this.client), -1).ifPresent(target);
            this.createAchievementMeasurementInternal(achievementDiary.name(), "HARD", achievementDiary.getHard(this.client), -1).ifPresent(target);
            this.createAchievementMeasurementInternal(achievementDiary.name(), "ELITE", achievementDiary.getElite(this.client), -1).ifPresent(target);
        }
        for (Enum enum_ : CombatAchievement.values()) {
            this.createAchievementMeasurementInternal("COMBAT", enum_.name(), ((CombatAchievement)enum_).getCompleted(this.client), ((CombatAchievement)enum_).getTotal(this.client)).ifPresent(target);
        }
    }

    private static String toTitleCase(String str) {
        Matcher matcher = SENTENCE_CASE_PATTERN.matcher(str);
        if (!matcher.find()) {
            return str;
        }
        StringBuilder dest = new StringBuilder(str.length());
        do {
            matcher.appendReplacement(dest, matcher.group(1) + matcher.group(2).toUpperCase());
        } while (matcher.find());
        matcher.appendTail(dest);
        return dest.toString();
    }

    private <T> Optional<T> loadProfileConfig(String group, String key, Function<String, T> parser) {
        String value = this.configManager.getRSProfileConfiguration(group, key);
        if (Strings.isNullOrEmpty(value)) {
            return Optional.empty();
        }
        try {
            return Optional.of(parser.apply(value));
        }
        catch (RuntimeException err) {
            return Optional.empty();
        }
    }

    public Series createKillCountSeries(String boss) {
        return this.createSeries().measurement(SERIES_KILL_COUNT).tag("boss", boss).build();
    }

    public Optional<Measurement> createKillCountMeasurement(String bossMixed) {
        String boss = bossMixed.toLowerCase();
        Integer killCount = (Integer)this.configManager.getRSProfileConfiguration(KILL_COUNT_CFG_GROUP, boss, Integer.TYPE);
        if (killCount == null) {
            return Optional.empty();
        }
        Double personalBest = (Double)this.configManager.getRSProfileConfiguration(PERSONAL_BEST_CFG_GROUP, boss, Double.TYPE);
        Measurement.MeasurementBuilder measurement = Measurement.builder().series(this.createKillCountSeries(boss)).numericValue("kc", killCount);
        if (personalBest != null) {
            measurement.numericValue("pb", personalBest.intValue());
            measurement.numericValue("pb_float", Float.valueOf(personalBest.floatValue()));
        }
        return Optional.of(measurement.build());
    }

    public Optional<Series> createActivitySeries() {
        Series series = this.createSeries().measurement(SERIES_ACTIVITY).build();
        if (Strings.isNullOrEmpty(series.getTags().getOrDefault("user", null))) {
            return Optional.empty();
        }
        return Optional.of(series);
    }

    public Optional<Measurement> createActivityMeasurement(ActivityState.State lastState) {
        Measurement measure;
        Optional<Series> series = this.createActivitySeries();
        if (!series.isPresent()) {
            return Optional.empty();
        }
        Measurement.MeasurementBuilder mb = Measurement.builder().series(series.get());
        if (!Strings.isNullOrEmpty(lastState.getSkill())) {
            mb.stringValue("skill", lastState.getSkill());
        }
        if (!Strings.isNullOrEmpty(lastState.getLocationType())) {
            mb.stringValue("type", lastState.getLocationType());
        }
        if (!Strings.isNullOrEmpty(lastState.getLocation())) {
            mb.stringValue("location", lastState.getLocation());
        }
        if ((measure = mb.build()).getStringValues().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(measure);
    }

    public Series createLootSeries(LootRecordType type, String source, int combatLevel) {
        return this.createSeries().measurement(SERIES_LOOT).tag("type", type.name()).tag("source", source).tag("combat", Integer.toString(combatLevel)).build();
    }

    public Optional<Measurement> createLootMeasurement(LootReceived event) {
        Measurement.MeasurementBuilder measurement = Measurement.builder().series(this.createLootSeries(event.getType(), event.getName(), event.getCombatLevel()));
        Optional<WorldPoint> worldPoint = event.getItems().stream().filter(Objects::nonNull).map(stack -> WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)stack.getLocation())).findAny();
        if (!worldPoint.isPresent()) {
            return Optional.empty();
        }
        WorldPoint location = worldPoint.get();
        measurement.numericValue(SELF_KEY_X, location.getX()).numericValue(SELF_KEY_Y, location.getY()).numericValue("plane", location.getPlane()).numericValue(KILL_COUNT_CFG_GROUP, 1);
        HashMultiset<String> counts = HashMultiset.create(event.getItems().size());
        for (ItemStack itemStack : event.getItems()) {
            if (itemStack.getQuantity() <= 0) continue;
            int canonId = this.itemManager.canonicalize(itemStack.getId());
            ItemComposition data = this.itemManager.getItemComposition(canonId);
            counts.add(MeasurementCreator.itemToKey(data), itemStack.getQuantity());
        }
        if (counts.isEmpty()) {
            return Optional.empty();
        }
        for (Multiset.Entry entry : counts.entrySet()) {
            measurement.numericValue((String)entry.getElement(), entry.getCount());
        }
        return Optional.of(measurement.build());
    }

    public Series createSkillingItemSeries(Skill skill, ItemComposition item) {
        return this.createSeries().measurement(SERIES_SKILLING_ITEMS).tag("skill", skill.name()).tag("item", MeasurementCreator.itemToKey(item)).build();
    }

    public Measurement createSkillingItemMeasurement(Skill skill, int xp, float weightedXp, ItemComposition item, long count) {
        return Measurement.builder().series(this.createSkillingItemSeries(skill, item)).numericValue("xp", xp).numericValue("weightedXp", Float.valueOf(weightedXp)).numericValue("itemCount", count).numericValue("actionCount", 1).build();
    }

    public static enum InvValueType {
        GE,
        HA,
        COUNT;

    }
}

