/*
 * Decompiled with CFR 0.152.
 */
package net.machpi.runelite.influxdb;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="influxdb")
public interface InfluxDbConfig
extends Config {
    public static final String GROUP = "influxdb";
    public static final String WRITE_INTERVAL = "writeInterval";

    @ConfigItem(keyName="serverUrl", name="Server URL", description="URL of the influx DB api to write to", position=0)
    public String getServerUrl();

    @ConfigItem(keyName="serverDatabase", name="Database", description="Database to write to", position=1)
    public String getDatabase();

    @ConfigItem(keyName="serverUsername", name="Server Username", description="Username to use for authentication", position=2)
    default public String getServerUsername() {
        return "";
    }

    @ConfigItem(keyName="serverPassword", name="Server Password", description="Password to use for authentication", position=3, secret=true)
    default public String getServerPassword() {
        return "";
    }

    @ConfigItem(keyName="serverRetentionPolicy", name="Server Retention Policy", description="Retention policy to use for storing data", position=4)
    default public String getServerRetentionPolicy() {
        return "autogen";
    }

    @ConfigItem(keyName="writeXp", name="Submit Experience", description="Submit experience amount", position=5)
    default public boolean writeXp() {
        return true;
    }

    @ConfigItem(keyName="writeBankValue", name="Submit Bank Value", description="Submit bank and seed vault items", position=6)
    default public boolean writeBankValue() {
        return true;
    }

    @ConfigItem(keyName="writeSelfLoc", name="Submit Player Location", description="Submit player location", position=7)
    default public boolean writeSelfLoc() {
        return false;
    }

    @ConfigItem(keyName="writeSelfMeta", name="Submit Player Metadata", description="Submit player combat level, quest points, and other minor stats", position=8)
    default public boolean writeSelfMeta() {
        return true;
    }

    @ConfigItem(keyName="writeKillCount", name="Submit Kill Count", description="Submits boss kill counts (requires Chat Commands plugin)", position=9)
    default public boolean writeKillCount() {
        return true;
    }

    @ConfigItem(keyName="writeActivity", name="Submit Activity", description="Submit player activity such as location names, skill training, minigame, raid, or boss", position=10)
    default public boolean writeActivity() {
        return true;
    }

    @ConfigItem(keyName="writeLoot", name="Submit Loot", description="Submit loot events provided by the Loot Tracker plugin", position=11)
    default public boolean writeLoot() {
        return false;
    }

    @ConfigItem(keyName="writeSkillingItems", name="Submit Skilling Items", description="Submit skilling xp and item pairs", position=12)
    default public boolean writeSkillingItems() {
        return false;
    }

    @ConfigItem(keyName="writeInterval", name="Recording interval", description="Minimum interval between measurements", position=13)
    @Units(value="s")
    @Range(min=5, max=300)
    default public int writeIntervalSeconds() {
        return 15;
    }

    @ConfigItem(keyName="activityTimeout", name="Activity timeout", description="Configures after how long of not updating activity will be reset (in minutes)", position=14)
    @Units(value=" mins")
    default public int activityTimeout() {
        return 5;
    }
}

