/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.AfkTimerConfig;
import com.google.inject.Provides;
import java.time.Duration;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="AFK Timer")
public class AfkTimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AfkTimerPlugin.class);
    private boolean alreadyTriggered = false;
    @Inject
    private Client client;
    @Inject
    private AfkTimerConfig config;
    @Inject
    private Notifier notifier;

    @Subscribe
    public void onGameTick(GameTick event) {
        Player local = this.client.getLocalPlayer();
        if (this.client.getGameState() == GameState.LOGGED_IN || local != null) {
            long lastKeyboardMillis = System.currentTimeMillis() - (long)(this.client.getKeyboardIdleTicks() * 600);
            long lastInteraction = Math.max(this.client.getMouseLastPressedMillis(), lastKeyboardMillis);
            Duration waitDuration = Duration.ofSeconds(this.config.afkTimer());
            if (System.currentTimeMillis() > lastInteraction + waitDuration.toMillis()) {
                if (!this.alreadyTriggered) {
                    this.alreadyTriggered = true;
                    log.info("Sending notification!");
                    this.notifier.notify("You have been AFK for " + waitDuration.getSeconds() + " seconds!");
                }
            } else {
                this.alreadyTriggered = false;
            }
        }
    }

    @Provides
    AfkTimerConfig provideConfig(ConfigManager configManager) {
        return (AfkTimerConfig)configManager.getConfig(AfkTimerConfig.class);
    }
}

