/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.rooftops.courses;

import tictac7x.rooftops.MarkOfGrace;
import tictac7x.rooftops.courses.Obstacle;

public abstract class Course {
    private final String id;
    private final int[] regions;
    private final Obstacle[] obstacles;
    private final MarkOfGrace[] mark_of_graces;
    private int obstacle_index = 0;
    private boolean doing_obstacle;

    public Course(String id, int[] regions, Obstacle[] obstacles, MarkOfGrace[] mark_of_graces) {
        this.id = id;
        this.regions = regions;
        this.obstacles = obstacles;
        this.mark_of_graces = mark_of_graces;
    }

    public String getId() {
        return this.id;
    }

    public int[] getRegions() {
        return this.regions;
    }

    public Obstacle[] getObstacles() {
        return this.obstacles;
    }

    public MarkOfGrace[] getMarkOfGraces() {
        return this.mark_of_graces;
    }

    public Obstacle getNextObstacle() {
        return this.obstacles[this.obstacle_index];
    }

    public void startObstacle() {
        if (this.doing_obstacle) {
            return;
        }
        this.doing_obstacle = true;
        this.obstacle_index = this.obstacle_index + 1 == this.obstacles.length ? 0 : this.obstacle_index + 1;
    }

    public void completeObstacle() {
        this.doing_obstacle = false;
    }

    public void reset() {
        this.doing_obstacle = false;
        this.obstacle_index = 0;
    }

    public boolean isDoingObstacle() {
        return this.doing_obstacle;
    }

    public boolean isInRegion(int region) {
        for (int r : this.regions) {
            if (r != region) continue;
            return true;
        }
        return false;
    }

    public boolean isNearRegion(int[] regions) {
        for (int region : regions) {
            for (int course_region : this.regions) {
                if (course_region != region) continue;
                return true;
            }
        }
        return false;
    }
}

