/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.rooftops;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.TileObject;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.StatChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tictac7x.rooftops.RooftopsConfig;
import tictac7x.rooftops.RooftopsCourseManager;
import tictac7x.rooftops.RooftopsOverlay;

@PluginDescriptor(name="Rooftop Agility Improved", description="Improved clickboxes for rooftop agility courses", tags={"roof", "rooftop", "agility", "mark", "grace", "graceful"})
public class RooftopsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RooftopsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlays;
    @Inject
    private RooftopsConfig config;
    private RooftopsCourseManager course_manager;
    private RooftopsOverlay overlay_rooftops;

    @Provides
    RooftopsConfig provideConfig(ConfigManager configManager) {
        return (RooftopsConfig)configManager.getConfig(RooftopsConfig.class);
    }

    protected void startUp() {
        this.course_manager = new RooftopsCourseManager(this.client);
        this.overlay_rooftops = new RooftopsOverlay(this.client, this.config, this.course_manager);
        this.overlays.add((Overlay)this.overlay_rooftops);
    }

    protected void shutDown() {
        this.overlays.remove((Overlay)this.overlay_rooftops);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.course_manager.onTileObjectSpawned((TileObject)event.getGameObject());
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        this.course_manager.onTileObjectSpawned((TileObject)event.getGroundObject());
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned event) {
        this.course_manager.onTileObjectSpawned((TileObject)event.getDecorativeObject());
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned event) {
        this.course_manager.onItemSpawned(event);
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned event) {
        this.course_manager.onItemDespawned(event);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        this.course_manager.onChatMessage(event);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        this.course_manager.onMenuOptionClicked(event);
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        this.course_manager.onStatChanged(event);
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        this.course_manager.onHitsplatApplied(event);
    }

    @Subscribe
    public void onGameTick(GameTick gametick) {
        this.course_manager.onGameTick(gametick);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.course_manager.onGameStateChanged(event);
    }
}

