/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.rooftops;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import net.runelite.api.Client;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import tictac7x.rooftops.RooftopsConfig;
import tictac7x.rooftops.RooftopsCourseManager;

public class RooftopsOverlay
extends Overlay {
    private final Client client;
    private final RooftopsConfig config;
    private final RooftopsCourseManager course_manager;

    public RooftopsOverlay(Client client, RooftopsConfig config, RooftopsCourseManager course_manager) {
        this.client = client;
        this.config = config;
        this.course_manager = course_manager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.course_manager.getCourse() == null || !this.course_manager.isNearCourse()) {
            return null;
        }
        for (TileObject obstacle : this.course_manager.getObstacles()) {
            Color color = this.course_manager.isStoppingObstacle(obstacle.getId()) ? this.config.getObstacleStopColor() : (this.course_manager.getCourse().getNextObstacle().hasId(obstacle.getId()) ? (this.course_manager.getCourse().isDoingObstacle() ? this.config.getObstacleNextUnavailableColor() : this.config.getObstacleNextColor()) : this.config.getObstacleUnavailableColor());
            this.renderShape(graphics, obstacle.getClickbox(), color);
        }
        for (Tile mark : this.course_manager.getMarksOfGraces()) {
            this.renderShape(graphics, mark.getItemLayer().getCanvasTilePoly(), this.config.getMarkOfGraceColor());
        }
        return null;
    }

    private void renderShape(Graphics2D graphics, Shape shape, Color color) {
        if (shape == null || color.getAlpha() == 0) {
            return;
        }
        try {
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), Math.min(255, color.getAlpha() + 20)));
            graphics.setStroke(new BasicStroke(1.0f));
            graphics.draw(shape);
            graphics.setColor(color);
            graphics.fill(shape);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

