/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.rooftops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.StatChanged;
import tictac7x.rooftops.MarkOfGrace;
import tictac7x.rooftops.courses.Course;
import tictac7x.rooftops.courses.Obstacle;
import tictac7x.rooftops.courses.RooftopCourseAlKharid;
import tictac7x.rooftops.courses.RooftopCourseArdougne;
import tictac7x.rooftops.courses.RooftopCourseCanifis;
import tictac7x.rooftops.courses.RooftopCourseDraynor;
import tictac7x.rooftops.courses.RooftopCourseFalador;
import tictac7x.rooftops.courses.RooftopCoursePollnivneach;
import tictac7x.rooftops.courses.RooftopCourseRellekka;
import tictac7x.rooftops.courses.RooftopCourseSeers;
import tictac7x.rooftops.courses.RooftopCourseVarrock;

public class RooftopsCourseManager {
    private final Client client;
    private final Pattern lap_complete = Pattern.compile(".*lap count is:.*");
    private final Course[] courses = new Course[]{new RooftopCourseDraynor(), new RooftopCourseAlKharid(), new RooftopCourseVarrock(), new RooftopCourseCanifis(), new RooftopCourseFalador(), new RooftopCourseSeers(), new RooftopCoursePollnivneach(), new RooftopCourseRellekka(), new RooftopCourseArdougne()};
    private final List<TileObject> obstacles = new ArrayList<TileObject>();
    private final List<Tile> marks_of_graces = new ArrayList<Tile>();
    private boolean obstacle_clicked;
    private int[] next_obstacle_ids;
    private int start_obstacle = -1;
    @Nullable
    private Course course;
    private boolean is_near_course;

    public RooftopsCourseManager(Client client) {
        this.client = client;
    }

    public void onTileObjectSpawned(TileObject object) {
        if (this.course == null) {
            return;
        }
        for (Obstacle obstacle : this.course.getObstacles()) {
            if (!obstacle.hasId(object.getId())) continue;
            this.obstacles.add(object);
        }
    }

    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.obstacles.clear();
        }
        this.detectCourse();
    }

    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getId() == 1 && event.getItemId() == -1 || event.getItemId() != -1 && !event.getMenuTarget().contains("->")) {
            return;
        }
        this.checkForClickedObstacle(event.getId());
    }

    public void onStatChanged(StatChanged event) {
        if (this.course == null || event.getSkill() != Skill.AGILITY) {
            return;
        }
        this.completeObstacle();
    }

    public void onHitsplatApplied(HitsplatApplied event) {
        if (this.course == null || event.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        this.resetCourse();
    }

    public void onGameTick(GameTick ignored) {
        this.checkNearCourse();
        this.checkStartObstacle();
    }

    public void onChatMessage(ChatMessage event) {
        if (this.course == null || event.getType() != ChatMessageType.GAMEMESSAGE || !this.lap_complete.matcher(event.getMessage()).find()) {
            return;
        }
        this.resetCourse();
    }

    public void onItemSpawned(ItemSpawned event) {
        if (event.getItem().getId() != 11849) {
            return;
        }
        this.marks_of_graces.add(event.getTile());
    }

    public void onItemDespawned(ItemDespawned event) {
        if (event.getItem().getId() != 11849) {
            return;
        }
        this.marks_of_graces.remove(event.getTile());
    }

    @Nullable
    public Course getCourse() {
        return this.course;
    }

    public List<TileObject> getObstacles() {
        return this.obstacles;
    }

    public List<Tile> getMarksOfGraces() {
        return this.marks_of_graces;
    }

    public boolean isNearCourse() {
        return this.is_near_course;
    }

    public boolean isStoppingObstacle(int obstacle_id) {
        if (this.course == null) {
            return false;
        }
        for (Tile tile : this.marks_of_graces) {
            for (MarkOfGrace mark : this.course.getMarkOfGraces()) {
                if (mark.obstacle != obstacle_id || mark.x != tile.getWorldLocation().getX() || mark.y != tile.getWorldLocation().getY()) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private TileObject getNextObstacle() {
        if (this.course == null) {
            return null;
        }
        for (TileObject obstacle : this.obstacles) {
            if (!this.course.getNextObstacle().hasId(obstacle.getId())) continue;
            return obstacle;
        }
        return null;
    }

    private boolean isNearObstacle() {
        if (this.course == null) {
            return false;
        }
        TileObject obstacle = this.getNextObstacle();
        if (obstacle == null) {
            return false;
        }
        Player player = this.client.getLocalPlayer();
        for (WorldPoint obstacle_point : this.course.getNextObstacle().locations) {
            if (player.getWorldLocation().distanceTo(obstacle_point) > 1) continue;
            return true;
        }
        return false;
    }

    private void startObstacle() {
        if (this.course == null) {
            return;
        }
        this.start_obstacle = -1;
        this.obstacle_clicked = false;
        this.course.startObstacle();
    }

    private void completeObstacle() {
        if (this.course == null) {
            return;
        }
        this.course.completeObstacle();
        this.next_obstacle_ids = this.course.getNextObstacle().getIds();
    }

    private void checkForClickedObstacle(int id) {
        if (this.course == null) {
            return;
        }
        if (Arrays.stream(this.next_obstacle_ids).anyMatch(i -> i == id)) {
            this.obstacle_clicked = true;
            if (this.isNearObstacle()) {
                this.start_obstacle = 1;
            }
        } else {
            this.obstacle_clicked = false;
        }
    }

    private void detectCourse() {
        int[] regions = this.client.getMapRegions();
        if (regions == null) {
            return;
        }
        for (Course course : this.courses) {
            if (!course.isNearRegion(regions) || this.course != null && this.course.isInRegion(this.client.getLocalPlayer().getWorldLocation().getRegionID())) continue;
            if (this.course != null && this.course != course) {
                this.course.reset();
            }
            if (this.course != course) {
                this.next_obstacle_ids = course.getNextObstacle().getIds();
            }
            this.course = course;
        }
    }

    private void checkNearCourse() {
        if (this.course == null) {
            return;
        }
        this.is_near_course = this.course.isInRegion(this.client.getLocalPlayer().getWorldLocation().getRegionID());
    }

    private void checkStartObstacle() {
        if (this.course == null) {
            return;
        }
        if (this.start_obstacle > 0) {
            --this.start_obstacle;
            return;
        }
        if (this.start_obstacle == 0) {
            this.startObstacle();
            return;
        }
        if (this.obstacle_clicked && this.isNearObstacle()) {
            this.start_obstacle = 1;
        }
    }

    private void resetCourse() {
        if (this.course == null) {
            return;
        }
        this.course.reset();
        this.next_obstacle_ids = this.course.getNextObstacle().getIds();
    }
}

