/*
 * Decompiled with CFR 0.152.
 */
package com.delps1001.systemtrayinventory;

import com.delps1001.systemtrayinventory.SystemTrayInventoryConfig;
import com.delps1001.systemtrayinventory.SystemTrayInventoryPluginException;
import com.google.inject.Provides;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.FontType;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.OSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="System Tray Inventory Count Plugin")
public class SystemTrayInventoryPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SystemTrayInventoryPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread c;
    @Inject
    private SpriteManager spriteManager;
    private static final int PADDING = 2;
    private TrayIcon trayIcon;
    private static final String TOOLTIP_TEXT_PLACEHOLDER = "%s Inventory Count";

    protected void startUp() {
        if (!SystemTray.isSupported()) {
            log.warn("System Tray is not supported, OS: {}", (Object)OSType.getOSType());
            throw new SystemTrayInventoryPluginException("System not supported");
        }
        SystemTray tray = SystemTray.getSystemTray();
        this.c.invokeLater(() -> {
            this.trayIcon = new TrayIcon(this.getImage(0), this.getToolTipText(""), null);
            try {
                tray.add(this.trayIcon);
            }
            catch (AWTException e) {
                log.error("Error adding tray image", (Throwable)e);
            }
        });
    }

    private String getToolTipText(String username) {
        return String.format(TOOLTIP_TEXT_PLACEHOLDER, username);
    }

    private Image getImage(int count) {
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D graphics2d = image.createGraphics();
        Font font = FontType.BOLD.getFont().deriveFont(26.0f);
        graphics2d.setFont(font);
        FontMetrics fontmetrics = graphics2d.getFontMetrics();
        int width = fontmetrics.stringWidth(String.valueOf(count));
        int height = fontmetrics.getHeight();
        graphics2d.dispose();
        Image inventorySprite = this.spriteManager.getSprite(900, 0).getScaledInstance(-1, height, 4);
        image = new BufferedImage(inventorySprite.getWidth(null) + 2 + width, height, 2);
        graphics2d = image.createGraphics();
        graphics2d.drawImage(inventorySprite, new AffineTransform(), null);
        graphics2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2d.setFont(font);
        fontmetrics = graphics2d.getFontMetrics();
        graphics2d.setColor(this.getColor(count));
        graphics2d.drawString(String.valueOf(count), inventorySprite.getWidth(null) + 2, fontmetrics.getAscent());
        graphics2d.dispose();
        return image;
    }

    private Color getColor(int count) {
        if (count == 28) {
            return Color.RED;
        }
        return Color.GRAY;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged e) {
        if (InventoryID.INVENTORY.getId() == e.getContainerId()) {
            ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
            assert (itemContainer != null);
            Item[] items = itemContainer.getItems();
            long totalItems = Arrays.stream(items).filter(i -> i.getQuantity() > 0).count();
            this.c.invokeLater(() -> this.trayIcon.setImage(this.getImage((int)totalItems)));
        }
    }

    protected void shutDown() {
        log.info("System Tray Inventory Plugin shutting down!");
        if (SystemTray.isSupported()) {
            SystemTray.getSystemTray().remove(this.trayIcon);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.trayIcon.setToolTip(this.getToolTipText(this.client.getLocalPlayer().getName()));
        }
    }

    @Provides
    SystemTrayInventoryConfig provideConfig(ConfigManager configManager) {
        return (SystemTrayInventoryConfig)configManager.getConfig(SystemTrayInventoryConfig.class);
    }
}

