/*
 * Decompiled with CFR 0.152.
 */
package com.sacredoil;

import com.google.inject.Provides;
import com.sacredoil.SacredOil;
import com.sacredoil.SacredOilConfig;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Sacred Oil", description="Send a notification when sanctity reaches threshold and/or adds a Flamtaer Bracelet counter", tags={"notifications", "oil"}, enabledByDefault=true)
public class SacredOilPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SacredOilPlugin.class);
    @Inject
    private Client client;
    @Inject
    private SacredOilConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Notifier notifier;
    private SacredOil counterbox;
    private Instant sanctityThresh;
    private int charge = 80;
    private boolean startTime = false;
    private boolean sancNotiSent = false;

    protected void startUp() {
        this.clientThread.invokeLater(() -> {
            ItemContainer container = this.client.getItemContainer(InventoryID.EQUIPMENT);
            if (container != null) {
                this.checkHand(container.getItems());
            }
        });
    }

    protected void shutDown() {
        this.removeInfobox();
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        this.startUp();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String prompt = "Your Flamtaer bracelet helps you build the temple quicker.";
        if ((event.getType() == ChatMessageType.SPAM || event.getType() == ChatMessageType.GAMEMESSAGE) && event.getMessage().contains("Your Flamtaer bracelet helps you build the temple quicker.")) {
            String num = event.getMessage().replaceAll("[^0-9]", "");
            this.charge = Integer.parseInt(num.replaceAll("^0+(?!$)", ""));
            if (this.charge == 0) {
                this.charge = 80;
                if (this.config.braceletNotify()) {
                    this.notifier.notify("Your Flamtaer Bracelet has broken!");
                }
            }
            this.updateInfobox(this.charge);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (this.config.braceletCounter()) {
            this.startUp();
            return;
        }
        this.removeInfobox();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.sendSancNoti();
    }

    private void checkHand(Item[] items) {
        if (items[EquipmentInventorySlot.GLOVES.getSlotIdx()].getId() == 21180) {
            this.updateInfobox(this.charge);
            return;
        }
        this.removeInfobox();
    }

    private void updateInfobox(int charge) {
        this.removeInfobox();
        if (this.config.braceletCounter()) {
            AsyncBufferedImage image = this.itemManager.getImage(21180, charge, false);
            this.counterbox = new SacredOil(this, 21180, charge, "Charges", (BufferedImage)image);
            this.infoBoxManager.addInfoBox((InfoBox)this.counterbox);
        }
    }

    private void removeInfobox() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.counterbox);
    }

    public void sendSancNoti() {
        int SANCTITY_ID;
        Widget widget;
        if (this.checkLocation() && (widget = this.client.getWidget(SANCTITY_ID = 11206665)) != null) {
            String count = widget.getText();
            int num = Integer.parseInt(count = count.replaceAll("[^0-9]", ""));
            if (num > this.config.sanctityNotify()) {
                if (!this.sancNotiSent) {
                    if (!this.startTime) {
                        this.sanctityThresh = Instant.now();
                        this.startTime = true;
                    }
                    if (Instant.now().compareTo(this.sanctityThresh.plus(Duration.ofMillis(this.config.getSanctityDelay()))) >= 0) {
                        this.notifier.notify("Sanctity has reached threshold");
                        this.sancNotiSent = true;
                    }
                }
            } else {
                this.sancNotiSent = false;
                this.startTime = false;
            }
        }
    }

    private boolean checkLocation() {
        WorldPoint playerPos = this.client.getLocalPlayer().getWorldLocation();
        int TEMPLE_REGION_ID = 13875;
        if (playerPos.getRegionID() != TEMPLE_REGION_ID) {
            return false;
        }
        int TEMPLE_LOCATION_NW_X = 47;
        int TEMPLE_LOCATION_SE_X = 53;
        if (playerPos.getRegionX() < TEMPLE_LOCATION_NW_X || playerPos.getRegionX() > TEMPLE_LOCATION_SE_X) {
            return false;
        }
        int TEMPLE_LOCATION_NW_Y = 55;
        int TEMPLE_LOCATION_SE_Y = 49;
        return playerPos.getRegionY() <= TEMPLE_LOCATION_NW_Y && playerPos.getRegionY() >= TEMPLE_LOCATION_SE_Y;
    }

    @Provides
    SacredOilConfig provideConfig(ConfigManager configManager) {
        return (SacredOilConfig)configManager.getConfig(SacredOilConfig.class);
    }
}

