/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.runelite.togindicator;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.ImageUtil;

@Singleton
public class TOGIndicatorOverlay
extends Overlay {
    private static final Map<Skill, Integer> widgetIds = new HashMap<Skill, Integer>();
    private final Client client;
    private final BufferedImage questIcon;

    @Inject
    public TOGIndicatorOverlay(Client client) {
        this.client = client;
        this.questIcon = ImageUtil.loadImageResource(TOGIndicatorOverlay.class, (String)"/quest-icon.png");
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        int skillExp;
        Widget skillsContainer = this.client.getWidget(WidgetInfo.SKILLS_CONTAINER);
        if (skillsContainer == null || skillsContainer.isHidden()) {
            return null;
        }
        int minExp = Integer.MAX_VALUE;
        for (Skill s : Skill.values()) {
            skillExp = this.client.getSkillExperience(s);
            if (skillExp >= minExp) continue;
            minExp = skillExp;
        }
        for (Skill s : Skill.values()) {
            int widgetId;
            skillExp = this.client.getSkillExperience(s);
            if (skillExp != minExp || (widgetId = widgetIds.getOrDefault(s, -1).intValue()) == -1) continue;
            Widget skillWidget = null;
            for (Widget w : skillsContainer.getStaticChildren()) {
                if (w.getId() != widgetId) continue;
                skillWidget = w;
                break;
            }
            if (skillWidget == null) continue;
            Rectangle r = skillWidget.getBounds();
            graphics.drawImage((Image)this.questIcon, r.x + r.width - this.questIcon.getWidth(), r.y, null);
        }
        return null;
    }

    static {
        widgetIds.put(Skill.ATTACK, 0x1400001);
        widgetIds.put(Skill.STRENGTH, 20971522);
        widgetIds.put(Skill.DEFENCE, 20971523);
        widgetIds.put(Skill.RANGED, 0x1400004);
        widgetIds.put(Skill.PRAYER, 20971525);
        widgetIds.put(Skill.MAGIC, 20971526);
        widgetIds.put(Skill.RUNECRAFT, 20971527);
        widgetIds.put(Skill.CONSTRUCTION, 20971528);
        widgetIds.put(Skill.HITPOINTS, 20971529);
        widgetIds.put(Skill.AGILITY, 20971530);
        widgetIds.put(Skill.HERBLORE, 20971531);
        widgetIds.put(Skill.THIEVING, 20971532);
        widgetIds.put(Skill.CRAFTING, 20971533);
        widgetIds.put(Skill.FLETCHING, 20971534);
        widgetIds.put(Skill.SLAYER, 20971535);
        widgetIds.put(Skill.HUNTER, 0x1400010);
        widgetIds.put(Skill.MINING, 0x1400011);
        widgetIds.put(Skill.SMITHING, 20971538);
        widgetIds.put(Skill.FISHING, 20971539);
        widgetIds.put(Skill.COOKING, 0x1400014);
        widgetIds.put(Skill.FIREMAKING, 20971541);
        widgetIds.put(Skill.WOODCUTTING, 20971542);
        widgetIds.put(Skill.FARMING, 20971543);
        widgetIds.put(Skill.OVERALL, 20971544);
    }
}

