/*
 * Decompiled with CFR 0.152.
 */
package abex.idlenotifier;

import abex.idlenotifier.AbexsIdleNotifierConfig;
import com.google.inject.Provides;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Abex's Idle Notifier")
public class AbexsIdleNotifierPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AbexsIdleNotifierPlugin.class);
    @Inject
    private Client client;
    @Inject
    private AbexsIdleNotifierConfig config;
    @Inject
    private Notifier notifier;
    private int id;
    private WorldPoint loc = null;

    protected void startUp() throws Exception {
        this.id = -1;
        this.loc = null;
    }

    private boolean shouldNotify(MenuOptionClicked ev) {
        switch (ev.getMenuOption()) {
            case "Mine": {
                switch (ev.getId()) {
                    case 31044: {
                        return false;
                    }
                }
                return true;
            }
            case "Cut": {
                return ev.getMenuTarget().contains("Redwood");
            }
            case "Chop down": 
            case "Chip": {
                return true;
            }
        }
        return false;
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked ev) {
        switch (ev.getMenuAction()) {
            case GAME_OBJECT_FIRST_OPTION: 
            case GAME_OBJECT_SECOND_OPTION: 
            case GAME_OBJECT_THIRD_OPTION: 
            case GAME_OBJECT_FOURTH_OPTION: 
            case GAME_OBJECT_FIFTH_OPTION: {
                if (this.shouldNotify(ev)) {
                    ObjectComposition lc = this.client.getObjectDefinition(ev.getId());
                    if (lc.getImpostorIds() != null) {
                        lc = lc.getImpostor();
                    }
                    this.id = lc.getId();
                    this.loc = WorldPoint.fromScene((Client)this.client, (int)ev.getParam0(), (int)ev.getParam1(), (int)this.client.getPlane());
                    break;
                }
            }
            default: {
                this.loc = null;
                this.id = -1;
            }
        }
    }

    private boolean check(TileObject o) {
        if (o == null) {
            return false;
        }
        ObjectComposition lc = this.client.getObjectDefinition(o.getId());
        if (lc.getImpostorIds() != null) {
            lc = lc.getImpostor();
        }
        return lc.getId() == this.id;
    }

    @Subscribe
    private void onGameTick(GameTick ev) {
        if (this.loc != null) {
            try {
                LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.loc);
                if (lp != null) {
                    ItemContainer ic;
                    Tile t = this.client.getScene().getTiles()[this.loc.getPlane()][lp.getSceneX()][lp.getSceneY()];
                    boolean found = this.check((TileObject)t.getWallObject());
                    for (GameObject o : t.getGameObjects()) {
                        found |= this.check((TileObject)o);
                    }
                    if (found && ((ic = this.client.getItemContainer(InventoryID.INVENTORY)) == null || ic.getItems().length < 28 || Stream.of(ic.getItems()).anyMatch(i -> i.getQuantity() == 0))) {
                        return;
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            this.id = -1;
            this.loc = null;
            this.notifier.notify("you not busy smorc");
        }
    }

    @Provides
    AbexsIdleNotifierConfig provideConfig(ConfigManager configManager) {
        return (AbexsIdleNotifierConfig)configManager.getConfig(AbexsIdleNotifierConfig.class);
    }
}

