/*
 * Decompiled with CFR 0.152.
 */
package com.discordlevelnotifications;

import com.discordlevelnotifications.DiscordWebhookBody;
import com.discordlevelnotifications.LevelNotificationsConfig;
import com.google.common.base.Strings;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.UsernameChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.DrawManager;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Discord Level Notifications")
public class LevelNotificationsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LevelNotificationsPlugin.class);
    private Hashtable<String, Integer> currentLevels;
    private ArrayList<String> leveledSkills;
    private boolean shouldSendMessage = false;
    private int ticksWaited = 0;
    @Inject
    private Client client;
    @Inject
    private LevelNotificationsConfig config;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private DrawManager drawManager;

    @Provides
    LevelNotificationsConfig provideConfig(ConfigManager configManager) {
        return (LevelNotificationsConfig)configManager.getConfig(LevelNotificationsConfig.class);
    }

    protected void startUp() throws Exception {
        this.currentLevels = new Hashtable();
        this.leveledSkills = new ArrayList();
    }

    protected void shutDown() throws Exception {
    }

    @Subscribe
    public void onUsernameChanged(UsernameChanged usernameChanged) {
        this.resetState();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState().equals((Object)GameState.LOGIN_SCREEN)) {
            this.resetState();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.shouldSendMessage) {
            return;
        }
        if (this.ticksWaited < 2) {
            ++this.ticksWaited;
            return;
        }
        this.shouldSendMessage = false;
        this.ticksWaited = 0;
        this.sendMessage();
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        String skillName = statChanged.getSkill().getName();
        int level = statChanged.getLevel();
        if (this.currentLevels.get(skillName) == null || this.currentLevels.get(skillName) == 0) {
            this.currentLevels.put(skillName, level);
            return;
        }
        if (this.currentLevels.get(skillName) != level) {
            this.currentLevels.put(skillName, level);
            if (this.shouldSendForThisLevel(level)) {
                this.leveledSkills.add(skillName);
                this.shouldSendMessage = true;
            }
        }
    }

    private boolean shouldSendForThisLevel(int level) {
        return level >= this.config.minLevel() && this.levelMeetsIntervalRequirement(level);
    }

    private boolean levelMeetsIntervalRequirement(int level) {
        return this.config.levelInterval() <= 1 || level == 99 || level % this.config.levelInterval() == 0;
    }

    private void sendMessage() {
        Object levelUpString = this.client.getLocalPlayer().getName();
        String[] skills = new String[this.leveledSkills.size()];
        skills = this.leveledSkills.toArray(skills);
        this.leveledSkills.clear();
        for (int i = 0; i < skills.length; ++i) {
            String skill = skills[i];
            this.leveledSkills.remove(skill);
            if (i > 0) {
                levelUpString = i == skills.length - 1 ? (String)levelUpString + " and " : (String)levelUpString + ", ";
            }
            levelUpString = (String)levelUpString + " leveled " + skill + " to " + this.currentLevels.get(skill);
        }
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent((String)levelUpString);
        this.sendWebhook(discordWebhookBody);
    }

    private void sendWebhook(DiscordWebhookBody discordWebhookBody) {
        String configUrl = this.config.webhook();
        if (Strings.isNullOrEmpty((String)configUrl)) {
            return;
        }
        HttpUrl url = HttpUrl.parse((String)configUrl);
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)discordWebhookBody));
        if (this.config.sendScreenshot()) {
            this.sendWebhookWithScreenshot(url, requestBodyBuilder);
        } else {
            this.buildRequestAndSend(url, requestBodyBuilder);
        }
    }

    private void sendWebhookWithScreenshot(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        this.drawManager.requestNextFrameListener(image -> {
            byte[] imageBytes;
            BufferedImage bufferedImage = (BufferedImage)image;
            try {
                imageBytes = LevelNotificationsPlugin.convertImageToByteArray(bufferedImage);
            }
            catch (IOException e) {
                log.warn("Error converting image to byte array", (Throwable)e);
                return;
            }
            requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageBytes));
            this.buildRequestAndSend(url, requestBodyBuilder);
        });
    }

    private void buildRequestAndSend(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.sendRequest(request);
    }

    private void sendRequest(Request request) {
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error submitting webhook", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
    }

    private static byte[] convertImageToByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void resetState() {
        this.currentLevels.clear();
        this.leveledSkills.clear();
        this.shouldSendMessage = false;
        this.ticksWaited = 0;
    }
}

