/*
 * Decompiled with CFR 0.152.
 */
package com.ectofuntusinfo;

import com.ectofuntusinfo.EctofuntusCounterType;
import com.ectofuntusinfo.EctofuntusInfoConfig;
import com.ectofuntusinfo.EctofuntusInfoPlugin;
import java.awt.Color;
import java.awt.image.BufferedImage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.util.QuantityFormatter;

public class EctofuntusInfobox
extends InfoBox {
    private final EctofuntusInfoPlugin plugin;
    private final EctofuntusInfoConfig config;

    public EctofuntusInfobox(BufferedImage image, EctofuntusInfoPlugin plugin, EctofuntusInfoConfig config) {
        super(image, (Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
    }

    public String getText() {
        int number = this.plugin.getStoredTokens();
        if (this.config.countRemaining()) {
            number = 1000 - number;
        }
        if (this.config.counterType() == EctofuntusCounterType.BONEMEAL) {
            number /= 5;
        }
        return QuantityFormatter.formatNumber((long)number);
    }

    public Color getTextColor() {
        int tokens = this.plugin.getStoredTokens();
        if (tokens >= 1000) {
            return Color.RED;
        }
        if (tokens >= 935) {
            return Color.ORANGE;
        }
        if (tokens >= 805) {
            return Color.YELLOW;
        }
        return null;
    }

    public String getTooltip() {
        int tokens = this.plugin.getStoredTokens();
        StringBuilder sb = new StringBuilder();
        sb.append("You have ").append(QuantityFormatter.formatNumber((long)tokens)).append(" Ecto-tokens to collect.");
        if (tokens >= 1000) {
            sb.append("</br>You must collect your Ecto-tokens before you can continue using the Ectofuntus.");
        } else {
            sb.append("</br>You can still use ").append(QuantityFormatter.formatNumber((long)((1000 - tokens) / 5))).append(" more Bonemeal on the Ectofuntus.");
        }
        return sb.toString();
    }

    public boolean render() {
        return this.plugin.isInEctofuntusRegion() && this.plugin.getStoredTokens() > 0;
    }
}

