/*
 * Decompiled with CFR 0.152.
 */
package com.ectofuntusinfo;

import com.ectofuntusinfo.EctofuntusCounterType;
import com.ectofuntusinfo.EctofuntusInfoConfig;
import com.ectofuntusinfo.EctofuntusInfobox;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Ectofuntus Info", description="Tells you how many Ecto-tokens you can collect", tags={"Ecto", "Token", "Ectotoken", "Ecto-token", "Funtus", "Ectofuntus"})
public class EctofuntusInfoPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EctofuntusInfoPlugin.class);
    private static final Set<Integer> ECTOFUNTUS_REGIONS = ImmutableSet.of((Object)14647, (Object)14746);
    private static final int LOWER_TOKEN_VARBIT = 4769;
    private static final int UPPER_TOKEN_VARBIT = 5671;
    public static final int TOKENS_PER_BONEMEAL = 5;
    public static final int MAX_TOKEN_AMOUNT = 1000;
    public static final int HIGH_WARN_TOKEN_AMOUNT = 935;
    public static final int LOW_WARN_TOKEN_AMOUNT = 805;
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private EctofuntusInfoConfig config;
    private EctofuntusInfobox infobox;
    private boolean inEctofuntusRegion;
    private int storedTokens;

    @Provides
    EctofuntusInfoConfig getConfig(ConfigManager configManager) {
        return (EctofuntusInfoConfig)configManager.getConfig(EctofuntusInfoConfig.class);
    }

    protected void startUp() throws Exception {
        this.inEctofuntusRegion = this.checkEctofuntusRegion();
        this.storedTokens = 0;
        this.setupInfoBox();
    }

    protected void shutDown() throws Exception {
        this.inEctofuntusRegion = false;
        this.storedTokens = 0;
        this.infoBoxManager.removeInfoBox((InfoBox)this.infobox);
        this.infobox = null;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOADING: {
                this.inEctofuntusRegion = this.checkEctofuntusRegion();
                break;
            }
            case LOGIN_SCREEN: {
                this.inEctofuntusRegion = false;
                this.storedTokens = 0;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.inEctofuntusRegion) {
            return;
        }
        int lower = this.client.getVarbitValue(4769) % 64;
        int upper = this.client.getVarbitValue(5671);
        this.storedTokens = upper * 256 + (lower + upper) % 5 * 64 + lower;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("ectofuntusinfo") && event.getKey().equals("counterType")) {
            this.setupInfoBox();
        }
    }

    private boolean checkEctofuntusRegion() {
        GameState gameState = this.client.getGameState();
        if (gameState != GameState.LOGGED_IN && gameState != GameState.LOADING) {
            return false;
        }
        return Arrays.stream(this.client.getMapRegions()).anyMatch(ECTOFUNTUS_REGIONS::contains);
    }

    private void setupInfoBox() {
        int item = this.config.counterType() == EctofuntusCounterType.BONEMEAL ? 4255 : 4278;
        if (this.infobox != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.infobox);
        }
        this.infobox = new EctofuntusInfobox((BufferedImage)this.itemManager.getImage(item, 10, false), this, this.config);
        this.infoBoxManager.addInfoBox((InfoBox)this.infobox);
    }

    public boolean isInEctofuntusRegion() {
        return this.inEctofuntusRegion;
    }

    public int getStoredTokens() {
        return this.storedTokens;
    }
}

