/*
 * Decompiled with CFR 0.152.
 */
package com.protectItemNotify.ProtectItemNotify;

import com.google.inject.Provides;
import com.protectItemNotify.ProtectItemNotify.ProtectItemNotifyConfig;
import com.protectItemNotify.ProtectItemNotify.ProtectItemNotifyOverlay;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Prayer;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Protect Item Notify")
public class ProtectItemNotifyPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ProtectItemNotifyPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ProtectItemNotifyConfig config;
    @Inject
    private ProtectItemNotifyOverlay protectItemNotifyOverlay;
    @Inject
    private OverlayManager overlayManager;
    private boolean protectItemOn = true;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.protectItemNotifyOverlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.protectItemNotifyOverlay);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.protectItemOn = !this.client.isPrayerActive(Prayer.PROTECT_ITEM);
    }

    @Provides
    ProtectItemNotifyConfig provideConfig(ConfigManager configManager) {
        return (ProtectItemNotifyConfig)configManager.getConfig(ProtectItemNotifyConfig.class);
    }

    public boolean isInPVP() {
        return this.client.getVar(8121) == 1;
    }

    public boolean isProtectItemOn() {
        return this.protectItemOn;
    }
}

