/*
 * Decompiled with CFR 0.152.
 */
package com.protectItemNotify.ProtectItemNotify;

import com.protectItemNotify.ProtectItemNotify.ProtectItemNotifyConfig;
import com.protectItemNotify.ProtectItemNotify.ProtectItemNotifyPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.util.ImageUtil;

public class ProtectItemNotifyOverlay
extends Overlay {
    private static final ScaledImage previouslyScaledImage = new ScaledImage();
    private static BufferedImage protectItemImage;
    private final ProtectItemNotifyPlugin plugin;
    private final ProtectItemNotifyConfig protectItemConfig;

    @Inject
    ProtectItemNotifyOverlay(ProtectItemNotifyPlugin plugin, ProtectItemNotifyConfig config) throws PluginInstantiationException {
        super((Plugin)plugin);
        this.setPriority(OverlayPriority.MED);
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.plugin = plugin;
        this.protectItemConfig = config;
        ProtectItemNotifyOverlay.loadProtectItemImage();
        ProtectItemNotifyOverlay.previouslyScaledImage.scale = 1;
        ProtectItemNotifyOverlay.previouslyScaledImage.scaledBufferedImage = protectItemImage;
    }

    private static void loadProtectItemImage() {
        protectItemImage = ImageUtil.getResourceStreamFromClass(ProtectItemNotifyPlugin.class, (String)"/protect-item.png");
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInPVP() && this.protectItemConfig.pvponly()) {
            return null;
        }
        if (!this.plugin.isProtectItemOn()) {
            return null;
        }
        BufferedImage scaledProtectItemImage = this.scaleImage(protectItemImage);
        ImageComponent imagePanelComponent = new ImageComponent(scaledProtectItemImage);
        return imagePanelComponent.render(graphics);
    }

    private BufferedImage scaleImage(BufferedImage protectItemImage) {
        if (ProtectItemNotifyOverlay.previouslyScaledImage.scale == this.protectItemConfig.scale() || this.protectItemConfig.scale() <= 0) {
            return ProtectItemNotifyOverlay.previouslyScaledImage.scaledBufferedImage;
        }
        int w = protectItemImage.getWidth();
        int h = protectItemImage.getHeight();
        BufferedImage scaledProtectItemImage = new BufferedImage(this.protectItemConfig.scale() * w, this.protectItemConfig.scale() * h, 2);
        AffineTransform at = new AffineTransform();
        at.scale(this.protectItemConfig.scale(), this.protectItemConfig.scale());
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        ProtectItemNotifyOverlay.previouslyScaledImage.scaledBufferedImage = scaledProtectItemImage = scaleOp.filter(protectItemImage, scaledProtectItemImage);
        ProtectItemNotifyOverlay.previouslyScaledImage.scale = this.protectItemConfig.scale();
        return scaledProtectItemImage;
    }

    private static class ScaledImage {
        private int scale;
        private BufferedImage scaledBufferedImage;

        private ScaledImage() {
        }
    }
}

