/*
 * Decompiled with CFR 0.152.
 */
package com.vmgasper;

import com.google.inject.Provides;
import com.vmgasper.VMGasperConfig;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="VMGasper", description="Gasps when platform in VM is about to disappear", enabledByDefault=false)
public class VMGasperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(VMGasperPlugin.class);
    private static final int PLATFORM_STAGE_3_ID = 31000;
    @Inject
    private Client client;
    @Inject
    private VMGasperConfig config;

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (event.getGameObject().getId() == 31000) {
            List players = this.client.getPlayers();
            for (Player player : players) {
                int playerX = player.getWorldLocation().getX();
                int playerY = player.getWorldLocation().getY();
                int objectX = event.getGameObject().getWorldLocation().getX();
                int objectY = event.getGameObject().getWorldLocation().getY();
                if (playerX != objectX || playerY != objectY) continue;
                player.setOverheadCycle(this.config.duration() > 0 ? this.config.duration() : 100);
                player.setOverheadText(!this.config.text().isEmpty() ? this.config.text() : "* Gasp *");
            }
        }
    }

    @Provides
    VMGasperConfig provideConfig(ConfigManager configManager) {
        return (VMGasperConfig)configManager.getConfig(VMGasperConfig.class);
    }
}

