/*
 * Decompiled with CFR 0.152.
 */
package com.music.rs3music;

import com.google.inject.Provides;
import com.music.rs3music.MusicWidgetInfo;
import com.music.rs3music.RS3MusicConfig;
import com.music.rs3music.RS3MusicPanel;
import com.music.rs3music.Track;
import jaco.mp3.player.MP3Player;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarClientIntChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="RS3 Music", description="Plays the RS3 variant of the current track being played in game.", tags={"music"})
public class RS3MusicPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RS3MusicPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private RS3MusicConfig config;
    @Inject
    private OverlayManager overlayManager;
    private static final String TRACK_LIST_REPO = "https://rs3.frunk.ovh/";
    private final int FADING_TRACK_STATE = 0;
    private final int PLAYING_TRACK_STATE = 1;
    private int currentPlayerState = 1;
    private NavigationButton navButton;
    private RS3MusicPanel panel;
    private Widget currentTrackBox;
    private String previousTrack = "";
    private String nextTrack = "";
    private final MP3Player trackPlayer = new MP3Player();
    private Thread handlePlayThread = null;
    private Map<String, Track> mp3Map = new HashMap<String, Track>();
    private ArrayList<String> availableTrackNameArray = new ArrayList();
    private Random rng = new Random();
    private Collection<Widget> tracks = null;
    private boolean remixAvailable = false;
    private boolean changingTracks = false;
    private boolean initializeTrack = true;

    private void buildMp3TrackMap() {
        try {
            String updatedCsv = this.getUpdatedListFromRepo();
            String delimiter = ",";
            for (String line : updatedCsv.split("\n")) {
                Track newTrack;
                String[] track = line.split(delimiter);
                if (track.length == 1) {
                    newTrack = new Track();
                    newTrack.name = track[0];
                    this.mp3Map.put(track[0], newTrack);
                    continue;
                }
                newTrack = new Track();
                newTrack.name = track[0];
                newTrack.link = (TRACK_LIST_REPO + track[1]).replace(" ", "%20");
                newTrack.credit = "Jagex";
                this.mp3Map.put(track[0], newTrack);
                this.availableTrackNameArray.add(track[0]);
            }
            log.info("Tracks successfully added to map.");
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private void changeCurrentTrack() {
        this.client.setMusicVolume(0);
        this.trackPlayer.setVolume(0);
        this.trackPlayer.stop();
        this.previousTrack = this.nextTrack;
        this.currentPlayerState = 1;
    }

    private String getUpdatedListFromRepo() {
        String rv = "";
        try {
            String inputLine;
            URL url = new URL(TRACK_LIST_REPO);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer content = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine + "\n");
            }
            in.close();
            rv = content.toString();
            connection.disconnect();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return rv;
    }

    private boolean isOnMusicTab() {
        return this.client.getVar(171) == 13;
    }

    private void tagRemixedTracks() {
        Widget musicList = this.client.getWidget(WidgetInfo.MUSIC_TRACK_LIST);
        if (this.tracks == null) {
            this.tracks = Arrays.stream(musicList.getDynamicChildren()).sorted(Comparator.comparing(Widget::getRelativeY)).collect(Collectors.toList());
        }
        for (Widget track : this.tracks) {
            Track mappedTrack = this.mp3Map.get(track.getText());
            if (mappedTrack == null || mappedTrack.link == null) continue;
            track.setTextColor(Color.CYAN.getRGB());
        }
    }

    private void playTrack(String trackName) {
        this.trackPlayer.getPlayList().clear();
        Track track = this.mp3Map.get(trackName);
        if (track != null && track.link != null) {
            this.remixAvailable = true;
            this.client.setMusicVolume(0);
            this.trackPlayer.setVolume(this.config.volume());
            Track finalTrack = track;
            this.handlePlayThread = new Thread(() -> {
                try {
                    String directLink = finalTrack.link;
                    this.trackPlayer.addToPlayList(new URI(directLink).toURL());
                    this.trackPlayer.play();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            if (this.config.log()) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "RS3 Music Notice: " + track.name, null);
            }
            this.handlePlayThread.start();
            this.initializeTrack = false;
        } else {
            this.remixAvailable = false;
        }
    }

    protected void startUp() throws Exception {
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon.png");
        this.panel = new RS3MusicPanel(this);
        this.navButton = NavigationButton.builder().tooltip("RS3 Music").icon(icon).priority(50).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.buildMp3TrackMap();
        log.info("RS3 Music started!");
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.trackPlayer.stop();
        log.info("RS3 Music stopped!");
    }

    @Subscribe
    public void onVarClientIntChanged(VarClientIntChanged varClientIntChanged) {
        if (this.isOnMusicTab()) {
            this.tagRemixedTracks();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.config.setMusicVolume(0);
        }
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            try {
                this.client.setMusicVolume(0);
                if (this.config.mute()) {
                    this.trackPlayer.setVolume(0);
                }
                this.trackPlayer.getPlayList().clear();
                Track track = this.mp3Map.get("Scape Main");
                if (track.link != null) {
                    this.remixAvailable = true;
                    this.trackPlayer.setVolume(this.config.volume());
                    this.handlePlayThread = new Thread(() -> {
                        try {
                            String directLink = track.link;
                            this.trackPlayer.addToPlayList(new URL(directLink));
                            this.trackPlayer.play();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                    this.handlePlayThread.start();
                } else {
                    this.remixAvailable = false;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() == 161) {
            Widget viewport = this.client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_OLD_SCHOOL_BOX);
            this.currentTrackBox = viewport.createChild(-1, 4);
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        Widget currentTrack = this.client.getWidget(MusicWidgetInfo.MUSIC_CURRENT_TRACK.getGroupId(), MusicWidgetInfo.MUSIC_CURRENT_TRACK.getChildId());
        if (!this.trackPlayer.isPlaying()) {
            this.playTrack(currentTrack.getText());
        }
        if (this.isOnMusicTab()) {
            this.tagRemixedTracks();
        }
        if (this.previousTrack != currentTrack.getText()) {
            this.changingTracks = true;
            this.nextTrack = currentTrack.getText();
            this.currentPlayerState = 0;
            this.initializeTrack = true;
        } else {
            this.changingTracks = false;
        }
        try {
            if (this.changingTracks && this.currentPlayerState == 0) {
                this.changeCurrentTrack();
            } else if (this.initializeTrack) {
                this.playTrack(currentTrack.getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.config.mute()) {
            this.trackPlayer.setVolume(0);
            this.client.setMusicVolume(0);
        } else if (this.remixAvailable) {
            if (this.currentPlayerState == 1) {
                if (this.trackPlayer.getVolume() < this.config.volume() && this.trackPlayer.getVolume() >= 0) {
                    int newVol = this.trackPlayer.getVolume() + 14;
                    if (newVol > 100) {
                        newVol = 100;
                    }
                    this.trackPlayer.setVolume(newVol);
                } else if (this.trackPlayer.getVolume() > this.config.volume()) {
                    this.trackPlayer.setVolume(this.config.volume());
                } else if (this.trackPlayer.getVolume() < 0) {
                    this.trackPlayer.setVolume(0);
                }
                this.client.setMusicVolume(0);
            }
        } else {
            this.trackPlayer.setVolume(0);
            this.client.setMusicVolume(this.config.volume());
        }
        if (this.currentTrackBox != null) {
            this.currentTrackBox.setText(currentTrack.getText());
            if (this.mp3Map.get(currentTrack.getText()) != null && this.mp3Map.get((Object)currentTrack.getText()).link != null) {
                currentTrack.setTextColor(Color.CYAN.getRGB());
            } else {
                currentTrack.setTextColor(Color.GREEN.getRGB());
            }
        }
    }

    @Provides
    RS3MusicConfig provideConfig(ConfigManager configManager) {
        return (RS3MusicConfig)configManager.getConfig(RS3MusicConfig.class);
    }

    public RS3MusicConfig getMusicConfig() {
        return this.config;
    }
}

