/*
 * Decompiled with CFR 0.152.
 */
package com.music.rs3music;

import com.music.rs3music.RS3MusicPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RS3MusicPanel
extends PluginPanel
implements ChangeListener,
ActionListener {
    private static final Logger log = LoggerFactory.getLogger(RS3MusicPanel.class);
    RS3MusicPlugin RS3MusicPlugin;

    public RS3MusicPanel(RS3MusicPlugin RS3MusicPlugin2) {
        super(false);
        this.RS3MusicPlugin = RS3MusicPlugin2;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        titlePanel.setLayout(new BorderLayout());
        JLabel title = new JLabel();
        title.setText("RS3 Music Controls");
        title.setForeground(Color.WHITE);
        titlePanel.add((Component)title, "West");
        this.add(titlePanel, "North");
        JPanel volumePanel = new JPanel();
        volumePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        volumePanel.setLayout(new FlowLayout());
        JLabel volumeLabel = new JLabel();
        volumeLabel.setText("Volume");
        volumeLabel.setForeground(Color.WHITE);
        JSlider volumeSlider = new JSlider(0, 0, 100, RS3MusicPlugin2.getMusicConfig().volume());
        volumeSlider.setBackground(Color.LIGHT_GRAY);
        volumeSlider.setName("volume");
        volumeSlider.addChangeListener(this);
        volumePanel.add(volumeLabel);
        volumePanel.add(volumeSlider);
        JPanel togglePanel = new JPanel();
        togglePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        togglePanel.setLayout(new GridLayout(0, 1));
        JLabel muteLabel = new JLabel();
        muteLabel.setText("Mute:");
        muteLabel.setForeground(Color.WHITE);
        JCheckBox muteCheckBox = new JCheckBox();
        muteCheckBox.setSelected(RS3MusicPlugin2.getMusicConfig().mute());
        muteCheckBox.setForeground(Color.WHITE);
        muteCheckBox.setName("mute");
        muteCheckBox.addActionListener(this);
        togglePanel.add(new JSeparator());
        togglePanel.add(muteLabel);
        togglePanel.add(muteCheckBox);
        JLabel logMusicChange = new JLabel();
        logMusicChange.setText("Log music change:");
        logMusicChange.setForeground(Color.WHITE);
        JCheckBox logCheckBox = new JCheckBox();
        logCheckBox.setSelected(RS3MusicPlugin2.getMusicConfig().log());
        logCheckBox.setForeground(Color.WHITE);
        logCheckBox.setName("log");
        logCheckBox.addActionListener(this);
        togglePanel.add(new JSeparator());
        togglePanel.add(logMusicChange);
        togglePanel.add(logCheckBox);
        volumePanel.add(togglePanel);
        this.add(volumePanel, "Center");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting() && source.getName() == "volume") {
            this.RS3MusicPlugin.getMusicConfig().setVolume(source.getValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBox source = (JCheckBox)e.getSource();
        if (source.getName() == "mute") {
            this.RS3MusicPlugin.getMusicConfig().setMute(source.isSelected());
        }
        if (source.getName() == "log") {
            this.RS3MusicPlugin.getMusicConfig().setLog(source.isSelected());
        }
    }
}

