/*
 * Decompiled with CFR 0.152.
 */
package com.blended420.bankvalue;

import com.blended420.bankvalue.BankValueConfig;
import com.blended420.bankvalue.BankValueOverlay;
import com.blended420.bankvalue.BankedItems;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bank Value Overlay", description="Adds an overlay showing your overall bank value")
public class BankValuePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BankValuePlugin.class);
    @Inject
    private Client client;
    @Inject
    ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private BankValueConfig config;
    @Inject
    private ChatCommandManager commandManager;
    @Inject
    private BankValueOverlay overlay;
    @Inject
    private OverlayManager overlayManager;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged e) {
        if (e.getItemContainer() == this.client.getItemContainer(InventoryID.BANK)) {
            Item[] items = this.client.getItemContainer(InventoryID.BANK).getItems();
            this.updateTotalBankValue(items);
        }
    }

    private void updateTotalBankValue(Item[] items) {
        BankedItems prices = this.calc(items);
        this.overlay.updateInventoryValue(prices.getGeValue(), prices.getHaValue());
    }

    BankedItems calc(Item[] items) {
        long geTotal = 0L;
        long haTotal = 0L;
        for (Item item : this.client.getItemContainer(InventoryID.BANK).getItems()) {
            boolean isPlaceholder;
            boolean bl = isPlaceholder = this.itemManager.getItemComposition(item.getId()).getPlaceholderTemplateId() != -1;
            if (item.getId() == 20594 && isPlaceholder) continue;
            String name = this.itemManager.getItemComposition(item.getId()).getName();
            int qty = item.getQuantity();
            geTotal += (long)(this.itemManager.getItemPrice(item.getId()) * qty);
            haTotal += (long)(this.getHaValue(item.getId()) * qty);
        }
        return new BankedItems(geTotal, haTotal);
    }

    private int getHaValue(int itemId) {
        switch (itemId) {
            case 995: {
                return 1;
            }
            case 13204: {
                return 1000;
            }
        }
        return this.itemManager.getItemComposition(itemId).getHaPrice();
    }

    @Provides
    BankValueConfig provideConfig(ConfigManager configManager) {
        return (BankValueConfig)configManager.getConfig(BankValueConfig.class);
    }
}

