/*
 * Decompiled with CFR 0.152.
 */
package com.blended420.bankvalue;

import com.blended420.bankvalue.BankValueConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.util.QuantityFormatter;

public class BankValueOverlay
extends Overlay {
    private final BankValueConfig config;
    private long haValue;
    private long geValue;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    public BankValueOverlay(BankValueConfig config) {
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        String overlayTitle = "Bank Info:";
        String geValueTxt = this.formatNumber(this.geValue);
        String haValueTxt = this.formatNumber(this.haValue);
        this.panelComponent.getChildren().add(TitleComponent.builder().text(overlayTitle).color(Color.GREEN).build());
        this.panelComponent.setPreferredSize(new Dimension(this.geValue == 0L ? 90 : graphics.getFontMetrics().stringWidth(geValueTxt) + 60, 0));
        this.panelComponent.getChildren().add(LineComponent.builder().left("GE:").right(geValueTxt).build());
        if (this.config.showHaValue()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("HA:").right(haValueTxt).build());
        }
        return this.panelComponent.render(graphics);
    }

    public void updateInventoryValue(long geValue, long haValue) {
        this.geValue = geValue;
        this.haValue = haValue;
    }

    private String formatNumber(long num) {
        return this.config.showPriceSuffix() ? QuantityFormatter.quantityToStackSize((long)num) : QuantityFormatter.formatNumber((long)num);
    }
}

