/*
 * Decompiled with CFR 0.152.
 */
package com.audible2ticking;

import com.audible2ticking.Audible2TickingConfig;
import com.audible2ticking.Audible2TickingOverlay;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Hitsplat;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Preferences;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Audible 2-Ticking", description="Plays sounds to aid with some 2-ticking allowing the player to at least look away from the screen.", tags={"skilling", "tick", "timers", "damage", "zero", "sound", "fishing"}, enabledByDefault=false)
public class Audible2TickingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(Audible2TickingPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Notifier notifier;
    private int inventoryCount;
    private int inventoryPreviousCount;
    int maxInventoryCount = 28;
    @Inject
    private Audible2TickingConfig config;
    @Inject
    private Audible2TickingOverlay overlay;
    @Inject
    private OverlayManager overlayManager;

    @Provides
    Audible2TickingConfig provideConfig(ConfigManager configManager) {
        return (Audible2TickingConfig)configManager.getConfig(Audible2TickingConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.reset();
        this.clientThread.invokeLater(() -> {
            ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
            if (container != null) {
                this.calculateInventory(container.getItems());
            }
        });
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.reset();
    }

    private void reset() {
        this.inventoryCount = 0;
        this.inventoryPreviousCount = 0;
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        Preferences preferences = this.client.getPreferences();
        int previousVolume = preferences.getSoundEffectVolume();
        Actor target = hitsplatApplied.getActor();
        Hitsplat hitsplat = hitsplatApplied.getHitsplat();
        if (target != this.client.getLocalPlayer()) {
            return;
        }
        if (hitsplat.getAmount() == 0 && this.config.tickVolume() > 0) {
            preferences.setSoundEffectVolume(this.config.tickVolume());
            this.client.playSoundEffect(3220, this.config.tickVolume());
        }
        preferences.setSoundEffectVolume(previousVolume);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        Preferences preferences = this.client.getPreferences();
        int previousVolume = preferences.getSoundEffectVolume();
        ItemContainer container = event.getItemContainer();
        if (container != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        this.calculateInventory(container.getItems());
        int openSlots = this.maxInventoryCount - this.inventoryCount;
        log.debug("Inventory count: {}", (Object)this.inventoryCount);
        log.debug("Open Inventory slots: {}", (Object)openSlots);
        log.debug("Previous Inventory slots: {}", (Object)this.inventoryPreviousCount);
        if (openSlots <= this.config.openSlotsLeftCount() && this.inventoryCount > this.inventoryPreviousCount) {
            preferences.setSoundEffectVolume(this.config.inventoryVolume());
            this.client.playSoundEffect(3817, this.config.inventoryVolume());
        }
        this.inventoryPreviousCount = this.inventoryCount;
        preferences.setSoundEffectVolume(previousVolume);
    }

    private void calculateInventory(Item[] inv) {
        this.inventoryCount = 0;
        for (Item item : inv) {
            if (item.getId() == -1) continue;
            ++this.inventoryCount;
        }
    }

    int getInventoryCount() {
        return this.inventoryCount;
    }

    int getInventoryPreviousCount() {
        return this.inventoryPreviousCount;
    }
}

