/*
 * Decompiled with CFR 0.152.
 */
package com.HighlightStackables;

import com.HighlightStackables.HighlightStackablesConfig;
import com.HighlightStackables.HighlightStackablesHotkeyListener;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.TileItem;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.grounditems.GroundItemsConfig;
import net.runelite.client.plugins.grounditems.GroundItemsOverlay;
import net.runelite.client.plugins.grounditems.GroundItemsPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Highlight Stackables")
@PluginDependency(value=GroundItemsPlugin.class)
public class HighlightStackablesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HighlightStackablesPlugin.class);
    private Item[] previousInventory = new Item[28];
    private List<String> spawnedItems;
    private List<String> spawnedItemsUnique;
    private List<String> removedItems;
    private Set<String> uniqueSet;
    private String formattedString;
    private boolean hotKeyPressed;
    @Inject
    private HighlightStackablesConfig config;
    @Inject
    private HighlightStackablesHotkeyListener hotkeyListener;
    @Inject
    private GroundItemsPlugin groundItemsPlugin;
    @Inject
    private GroundItemsConfig groundItemsConfig;
    @Inject
    private GroundItemsOverlay groundItemsOverlay;
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private KeyManager keyManager;

    @Provides
    HighlightStackablesConfig provideConfig(ConfigManager configManager) {
        return (HighlightStackablesConfig)configManager.getConfig(HighlightStackablesConfig.class);
    }

    protected void startUp() {
        this.spawnedItems = new ArrayList<String>();
        this.spawnedItemsUnique = new ArrayList<String>();
        this.removedItems = new ArrayList<String>();
        this.uniqueSet = new HashSet<String>();
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
        this.config.setOriginalItem(this.groundItemsConfig.getHighlightItems());
    }

    protected void shutDown() {
        this.groundItemsConfig.setHighlightedItem(this.config.getOrginalItems());
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
    }

    @Subscribe
    public void onClientShutdown(ClientShutdown event) {
        this.groundItemsConfig.setHighlightedItem(this.config.getOrginalItems());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.spawnedItems.clear();
            this.spawnedItemsUnique.clear();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.hotKeyPressed) {
            return;
        }
        if (this.spawnedItems.isEmpty() && !this.groundItemsConfig.getHighlightItems().equals(this.config.getOrginalItems())) {
            this.groundItemsConfig.setHighlightedItem(this.config.getOrginalItems());
        }
        if (!this.spawnedItems.isEmpty()) {
            this.formatString();
            Object finishedString = new String();
            finishedString = this.config.getOrginalItems() + "," + this.formattedString;
            if (finishedString != this.groundItemsConfig.getHighlightItems()) {
                this.sortItems();
                this.groundItemsConfig.setHighlightedItem(this.config.getOrginalItems() + "," + this.formattedString);
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("highlightStackables")) {
            this.groundItemsConfig.setHighlightedItem(this.config.getOrginalItems());
        }
    }

    private void sortItems() {
        for (String element : this.spawnedItems) {
            boolean alreadyExists = false;
            for (String uniqueElement : this.spawnedItemsUnique) {
                if (!element.contains(uniqueElement)) continue;
                alreadyExists = true;
                break;
            }
            if (alreadyExists) continue;
            this.spawnedItemsUnique.add(element);
        }
    }

    private void formatString() {
        this.formattedString = this.spawnedItemsUnique.toString();
        this.formattedString = this.formattedString.substring(1, this.formattedString.length() - 1);
        this.groundItemsConfig.setHighlightedItem(this.config.getOrginalItems() + "," + this.formattedString);
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        TileItem item = itemSpawned.getItem();
        int id = item.getId();
        ItemComposition itemComposition = this.itemManager.getItemComposition(id);
        String exclusionList = this.groundItemsConfig.getHiddenItems().toString();
        if (itemComposition.isStackable() && !exclusionList.contains(itemComposition.getName())) {
            if (this.config.inventoryMode()) {
                if (inventory != null && inventory.contains(itemComposition.getId())) {
                    this.spawnedItems.add(itemComposition.getName());
                    if (this.hotKeyPressed) {
                        return;
                    }
                    this.groundItemsConfig.setHighlightedItem(this.config.getOrginalItems());
                    if (this.removedItems.contains(itemComposition.getName())) {
                        for (String element : this.removedItems) {
                            if (!element.equals(itemComposition.getName())) continue;
                            this.spawnedItems.add(element);
                        }
                    }
                    this.sortItems();
                    this.formatString();
                }
            } else {
                this.spawnedItems.add(itemComposition.getName());
                if (this.hotKeyPressed) {
                    return;
                }
                this.groundItemsConfig.setHighlightedItem(this.config.getOrginalItems());
                this.sortItems();
                this.formatString();
            }
        }
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned itemDespawned) {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        TileItem item = itemDespawned.getItem();
        int id = item.getId();
        ItemComposition itemComposition = this.itemManager.getItemComposition(id);
        this.spawnedItems.remove(itemComposition.getName());
        this.removedItems.remove(itemComposition.getName());
        this.spawnedItemsUnique.removeIf(element -> !this.spawnedItems.contains(element));
        if (this.hotKeyPressed) {
            return;
        }
        this.sortItems();
        this.formatString();
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        if (event.getItemContainer() == inventory) {
            Item[] currentItems = event.getItemContainer().getItems();
            for (int i = 0; i < currentItems.length; ++i) {
                Item currentItem = currentItems[i];
                Item previousItem = this.previousInventory[i];
                if (previousItem == null || currentItem.getId() != -1 || previousItem.getId() == currentItem.getId()) continue;
                ItemComposition removedItemComposition = this.itemManager.getItemComposition(previousItem.getId());
                if (inventory == null || inventory.contains(removedItemComposition.getId())) continue;
                for (String item2 : this.spawnedItems) {
                    if (!item2.equals(removedItemComposition.getName())) continue;
                    this.removedItems.add(item2);
                }
                this.spawnedItems.removeIf(item -> item.equals(removedItemComposition.getName()));
                this.spawnedItemsUnique.removeIf(element -> !this.spawnedItems.contains(element));
                this.sortItems();
                this.formatString();
            }
            this.previousInventory = (Item[])currentItems.clone();
        }
    }

    boolean isHotKeyPressed() {
        return this.hotKeyPressed;
    }

    void setHotKeyPressed(boolean hotKeyPressed) {
        this.hotKeyPressed = hotKeyPressed;
    }
}

