/*
 * Decompiled with CFR 0.152.
 */
package com.HighlightStackables;

import com.HighlightStackables.HighlightStackablesConfig;
import com.HighlightStackables.HighlightStackablesPlugin;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.client.plugins.grounditems.GroundItemsConfig;
import net.runelite.client.util.HotkeyListener;

class HighlightStackablesHotkeyListener
extends HotkeyListener {
    private final HighlightStackablesPlugin plugin;
    private final HighlightStackablesConfig config;
    private Instant lastPress;
    @Inject
    private GroundItemsConfig groundItemsConfig;

    @Inject
    private HighlightStackablesHotkeyListener(HighlightStackablesPlugin plugin, HighlightStackablesConfig config) {
        super(config::hotkey);
        this.plugin = plugin;
        this.config = config;
    }

    public void hotkeyPressed() {
        if (this.config.pauseMode()) {
            this.groundItemsConfig.setHighlightedItem(this.config.getOrginalItems());
            this.plugin.setHotKeyPressed(true);
            this.lastPress = Instant.now();
        }
    }

    public void hotkeyReleased() {
        if (this.config.pauseMode()) {
            this.config.setOriginalItem(this.groundItemsConfig.getHighlightItems());
            this.plugin.setHotKeyPressed(false);
        }
    }
}

