/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.views.transactions;

import com.flipper.helpers.Numbers;
import com.flipper.helpers.Timestamps;
import com.flipper.helpers.UiUtilities;
import com.flipper.models.Transaction;
import com.flipper.views.components.AmountProgressBar;
import com.flipper.views.components.DeleteButton;
import com.flipper.views.components.ItemHeader;
import com.google.common.base.Supplier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.UUID;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;

public class TransactionPanel
extends JPanel {
    JPanel container;
    private final int LABEL_COUNT = 3;
    private JPanel leftInfoTextPanel = new JPanel(new GridLayout(3, 1));
    private JPanel rightValuesPanel = new JPanel(new GridLayout(3, 1));
    private Transaction transaction;
    private Supplier<JButton> renderExtraComponentSupplier;
    private Consumer<Transaction> extraComponentPressedConsumer;

    public TransactionPanel(String name, Transaction transaction, ItemManager itemManager, Consumer<UUID> removeTransactionConsumer, boolean isPrompt, Supplier<JButton> renderExtraComponentSupplier, Consumer<Transaction> extraComponentPressedConsumer) {
        this.renderExtraComponentSupplier = renderExtraComponentSupplier;
        this.extraComponentPressedConsumer = extraComponentPressedConsumer;
        this.init(name, transaction, itemManager, removeTransactionConsumer, isPrompt);
    }

    public TransactionPanel(String name, Transaction transaction, ItemManager itemManager, Consumer<UUID> removeTransactionConsumer, boolean isPrompt) {
        this.init(name, transaction, itemManager, removeTransactionConsumer, isPrompt);
    }

    private void init(String name, Transaction transaction, ItemManager itemManager, Consumer<UUID> removeTransactionConsumer, boolean isPrompt) {
        SwingUtilities.invokeLater(() -> {
            this.transaction = transaction;
            this.setLayout(new BorderLayout());
            this.setBackground(ColorScheme.DARK_GRAY_COLOR);
            DeleteButton deleteTransactionButton = new DeleteButton(action -> {
                int input;
                String describeTransaction = transaction.describeTransaction();
                int n = input = isPrompt ? JOptionPane.showConfirmDialog(null, "Delete " + name + " of " + describeTransaction + "?") : 0;
                if (input == 0) {
                    removeTransactionConsumer.accept(transaction.getId());
                    this.setVisible(false);
                }
            });
            ItemComposition itemComp = itemManager.getItemComposition(transaction.getItemId());
            this.container = new JPanel();
            this.container.setLayout(new BorderLayout());
            this.container.setBackground(ColorScheme.DARK_GRAY_COLOR);
            this.container.add((Component)new ItemHeader(transaction.getItemId(), transaction.getPricePer(), itemComp.getName(), itemManager, false, deleteTransactionButton), "North");
            this.leftInfoTextPanel.setBorder(new EmptyBorder(2, 5, 2, 10));
            this.rightValuesPanel.setBorder(new EmptyBorder(2, 5, 2, 10));
            this.constructItemInfo();
            if (transaction.getQuantity() != transaction.getTotalQuantity()) {
                this.container.add((Component)((Object)new AmountProgressBar(transaction)), "South");
            } else {
                JButton extraComponent = (JButton)this.renderExtraComponentSupplier.get();
                if (extraComponent != null && !transaction.isAlched()) {
                    extraComponent.addActionListener(event -> {
                        this.extraComponentPressedConsumer.accept(transaction);
                        extraComponent.setVisible(false);
                    });
                    this.container.add((Component)extraComponent, "South");
                }
            }
            this.container.setBorder(UiUtilities.ITEM_INFO_BORDER);
            this.add((Component)this.container, "North");
            this.setBorder(new EmptyBorder(0, 5, 3, 5));
        });
    }

    private JLabel newLeftLabel(String text) {
        JLabel newJLabel = new JLabel(text);
        newJLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        newJLabel.setBorder(new EmptyBorder(0, 0, 2, 0));
        return newJLabel;
    }

    private JLabel newRightLabel(String value, Color fontColor) {
        JLabel newRightLabel = new JLabel(value);
        newRightLabel.setHorizontalAlignment(4);
        newRightLabel.setForeground(fontColor);
        newRightLabel.setBorder(new EmptyBorder(0, 0, 2, 0));
        return newRightLabel;
    }

    private void addLeftLabel(JLabel newLeftLabel) {
        this.leftInfoTextPanel.add(newLeftLabel);
    }

    private void addRightLabel(JLabel newRightLabel) {
        this.rightValuesPanel.add(newRightLabel);
    }

    private void constructItemInfo() {
        JPanel itemInfoContainer = new JPanel();
        itemInfoContainer.setLayout(new BorderLayout());
        String pricePerString = Numbers.numberWithCommas(this.transaction.getPricePer());
        String quantityString = Numbers.numberWithCommas(this.transaction.getQuantity());
        String totalQuantityString = Numbers.numberWithCommas(this.transaction.getTotalQuantity());
        JLabel pricePerLabel = this.newLeftLabel("Price Per:");
        JLabel pricePerValue = this.newRightLabel(pricePerString, ColorScheme.GRAND_EXCHANGE_ALCH);
        this.addLeftLabel(pricePerLabel);
        this.addRightLabel(pricePerValue);
        String quantityValueText = this.transaction.isFilled() ? quantityString : String.valueOf(quantityString + "/" + totalQuantityString);
        JLabel quantityLabel = this.newLeftLabel("Quantity:");
        JLabel quantityValue = this.newRightLabel(quantityValueText, ColorScheme.GRAND_EXCHANGE_ALCH);
        this.addLeftLabel(quantityLabel);
        this.addRightLabel(quantityValue);
        JLabel dateLabel = this.newLeftLabel("Date:");
        JLabel dateValue = this.newRightLabel(Timestamps.format(this.transaction.getCreatedTime()), ColorScheme.GRAND_EXCHANGE_ALCH);
        this.addLeftLabel(dateLabel);
        this.addRightLabel(dateValue);
        itemInfoContainer.add((Component)this.leftInfoTextPanel, "West");
        itemInfoContainer.add((Component)this.rightValuesPanel, "East");
        this.container.add((Component)itemInfoContainer, "Center");
    }
}

