/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.views.transactions;

import com.flipper.views.components.SearchBar;
import com.flipper.views.transactions.TransactionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;

public class TransactionPage
extends JPanel {
    private JPanel container;

    public TransactionPage(Consumer<String> onSearchTextChanged) {
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.addSearchText(onSearchTextChanged);
        this.build();
    }

    private void addSearchText(Consumer<String> onSearchTextChanged) {
        SearchBar searchBar = new SearchBar(onSearchTextChanged);
        this.add((Component)searchBar, "North");
    }

    public void resetContainer() {
        this.container.removeAll();
    }

    public void build() {
        JPanel scrollContainer = new JPanel();
        scrollContainer.setLayout(new BorderLayout());
        this.container = new JPanel();
        this.container.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.container.setLayout(new BoxLayout(this.container, 3));
        this.container.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JScrollPane scrollPane = new JScrollPane(scrollContainer);
        scrollPane.setBackground(ColorScheme.LIGHT_GRAY_COLOR);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollContainer.add((Component)this.container, "First");
        this.add((Component)scrollPane, "Center");
    }

    public void addTransactionPanel(TransactionPanel transactionPanel) {
        this.container.add((Component)transactionPanel, "Center");
        this.revalidate();
    }
}

