/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.views.margins;

import com.flipper.helpers.Numbers;
import com.flipper.helpers.Timestamps;
import com.flipper.helpers.UiUtilities;
import com.flipper.models.Flip;
import com.flipper.views.components.DeleteButton;
import com.flipper.views.components.ItemHeader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.UUID;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;

public class MarginPanel
extends JPanel {
    private Flip margin;
    private final int LABEL_COUNT = 4;
    private JPanel container = new JPanel();
    private JPanel itemInfo = new JPanel(new BorderLayout());
    private JPanel leftInfoTextPanel = new JPanel(new GridLayout(4, 1));
    private JPanel rightValuesPanel = new JPanel(new GridLayout(4, 1));

    public MarginPanel(Flip margin, ItemManager itemManager, Consumer<UUID> removeMarginConsumer, boolean isPrompt, Consumer<Flip> convertToFlipConsumer) {
        SwingUtilities.invokeLater(() -> {
            this.margin = margin;
            DeleteButton deleteMarginButton = new DeleteButton(action -> {
                int input;
                int n = input = isPrompt ? JOptionPane.showConfirmDialog(null, "Delete margin check?") : 0;
                if (input == 0) {
                    removeMarginConsumer.accept(margin.getId());
                    this.setVisible(false);
                }
            });
            ItemComposition itemComp = itemManager.getItemComposition(margin.getItemId());
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(0, 5, 3, 5));
            this.container.setLayout(new BorderLayout());
            this.setBackground(ColorScheme.DARK_GRAY_COLOR);
            this.container.add((Component)new ItemHeader(margin.getItemId(), 0, itemComp.getName(), itemManager, false, deleteMarginButton), "North");
            this.constructItemInfo();
            JButton convertToFlipButton = new JButton("Convert To Flip");
            convertToFlipButton.addActionListener(event -> convertToFlipConsumer.accept(margin));
            this.container.add((Component)convertToFlipButton, "South");
            this.container.setBorder(UiUtilities.ITEM_INFO_BORDER);
            this.add((Component)this.container, "North");
        });
    }

    private void constructItemInfo() {
        this.constructLeftLabels();
        this.constructRightLabels();
        this.itemInfo.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.itemInfo.add((Component)this.leftInfoTextPanel, "West");
        this.itemInfo.add((Component)this.rightValuesPanel, "East");
        this.container.add((Component)this.itemInfo, "Center");
    }

    private JLabel newLeftLabel(String text) {
        JLabel newJLabel = new JLabel(text);
        newJLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        newJLabel.setBorder(new EmptyBorder(0, 0, 2, 0));
        return newJLabel;
    }

    private void addLeftLabel(JLabel newLeftLabel) {
        this.leftInfoTextPanel.add(newLeftLabel);
    }

    private void constructLeftLabels() {
        this.leftInfoTextPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JLabel buyAtLabel = this.newLeftLabel("Buy At:");
        JLabel sellAtLabel = this.newLeftLabel("Sell At:");
        JLabel potentialProfitLabel = this.newLeftLabel("Profit Per:");
        JLabel dateLabel = this.newLeftLabel("Date:");
        this.addLeftLabel(buyAtLabel);
        this.addLeftLabel(sellAtLabel);
        this.addLeftLabel(potentialProfitLabel);
        this.addLeftLabel(dateLabel);
        this.leftInfoTextPanel.setBorder(new EmptyBorder(2, 5, 2, 10));
    }

    private JLabel newRightLabel(String value) {
        JLabel newRightLabel = new JLabel(value);
        newRightLabel.setHorizontalAlignment(4);
        newRightLabel.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        newRightLabel.setBorder(new EmptyBorder(0, 0, 2, 0));
        return newRightLabel;
    }

    private void addRightLabel(JLabel newRightLabel) {
        this.rightValuesPanel.add(newRightLabel);
    }

    private void constructRightLabels() {
        this.rightValuesPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        int potentialProfitPer = this.margin.buyPrice - this.margin.sellPrice;
        String buyAtText = Integer.toString(this.margin.sellPrice);
        String sellAtText = Integer.toString(this.margin.buyPrice);
        String potentialProfitEachText = Integer.toString(potentialProfitPer);
        JLabel buyAtLabel = this.newRightLabel(Numbers.numberWithCommas(buyAtText));
        JLabel sellAtLabel = this.newRightLabel(Numbers.numberWithCommas(sellAtText));
        JLabel potentialProfitEachLabel = this.newRightLabel(Numbers.numberWithCommas(potentialProfitEachText));
        String formattedTimestamp = this.margin.getCreatedAt() != null ? Timestamps.format(this.margin.getCreatedAt()) : "--";
        JLabel dateLabel = this.newRightLabel(formattedTimestamp);
        this.addRightLabel(buyAtLabel);
        this.addRightLabel(sellAtLabel);
        this.addRightLabel(potentialProfitEachLabel);
        this.addRightLabel(dateLabel);
        this.rightValuesPanel.setBorder(new EmptyBorder(2, 5, 2, 10));
    }
}

