/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.views.margins;

import com.flipper.views.components.SearchBar;
import com.flipper.views.margins.MarginPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;

public class MarginPage
extends JPanel {
    private JPanel container;

    public MarginPage(Consumer<String> onSearchTextChangedCallback) {
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.addSearchBar(onSearchTextChangedCallback);
        this.build();
    }

    private void addSearchBar(Consumer<String> onSearchTextChangedCallback) {
        SearchBar searchBar = new SearchBar(onSearchTextChangedCallback);
        this.add((Component)searchBar, "North");
    }

    public void resetContainer() {
        this.container.removeAll();
    }

    public void addMarginPanel(MarginPanel marginPanel) {
        this.container.add((Component)marginPanel, "Center");
        this.revalidate();
    }

    public void build() {
        JPanel scrollContainer = new JPanel();
        scrollContainer.setLayout(new BorderLayout());
        this.container = new JPanel();
        this.container.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.container.setLayout(new BoxLayout(this.container, 3));
        this.container.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JScrollPane scrollPane = new JScrollPane(scrollContainer);
        scrollPane.setBackground(ColorScheme.LIGHT_GRAY_COLOR);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollContainer.add((Component)this.container, "First");
        this.add((Component)scrollPane, "Center");
    }
}

