/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.views.login;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.runelite.client.input.KeyListener;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class LoginPage
extends JPanel {
    private static final int PAGE_WIDTH = 225;
    JPanel loginContainer;
    private JButton loginButton;
    private JTextField emailTextField;
    private JTextField passwordTextField;
    Consumer<String> onEmailTextChangedListener;
    Consumer<String> onPasswordTextChangedListener;
    ActionListener onLoginPressedListener;

    public LoginPage(Consumer<String> onEmailTextChangedListener, Consumer<String> onPasswordTextChangedListener, ActionListener onLoginPressedListener) {
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setSize(225, 250);
        this.onEmailTextChangedListener = onEmailTextChangedListener;
        this.onPasswordTextChangedListener = onPasswordTextChangedListener;
        this.onLoginPressedListener = onLoginPressedListener;
        this.loginContainer = new JPanel();
        this.loginContainer.setLayout(new BoxLayout(this.loginContainer, 3));
        this.createLogo();
        this.createEmailInput();
        this.createPasswordInput();
        this.createLoginButton();
        this.createCreateAccountLink();
        this.add((Component)this.loginContainer, "North");
    }

    public void createLogo() {
        JPanel container = new JPanel();
        ImageIcon flipperIcon = new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)"/flipper_nav_button.png"));
        Image resizedLogo = flipperIcon.getImage().getScaledInstance(40, 40, 4);
        JLabel logoLabel = new JLabel(new ImageIcon(resizedLogo));
        logoLabel.setSize(40, 40);
        container.add((Component)logoLabel, "Center");
        container.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.loginContainer.add((Component)container, "Center");
    }

    public void createEmailInput() {
        JPanel container = new JPanel(new GridLayout(2, 1));
        container.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.emailTextField = new JTextField();
        this.emailTextField.setSize(225, 40);
        this.emailTextField.addKeyListener((java.awt.event.KeyListener)new KeyListener(){

            public void keyTyped(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                JTextField textField = (JTextField)event.getSource();
                String text = textField.getText();
                LoginPage.this.onEmailTextChangedListener.accept(text);
            }

            public void keyPressed(KeyEvent event) {
            }
        });
        JLabel emailLabel = new JLabel("Email");
        container.add((Component)emailLabel, "West");
        container.add(this.emailTextField);
        this.loginContainer.add((Component)container, "Center");
    }

    public void createPasswordInput() {
        JPanel container = new JPanel(new GridLayout(2, 1));
        container.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.passwordTextField = new JPasswordField();
        this.passwordTextField.setSize(225, 40);
        this.passwordTextField.addKeyListener((java.awt.event.KeyListener)new KeyListener(){

            public void keyTyped(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                JTextField textField = (JTextField)event.getSource();
                String text = textField.getText();
                LoginPage.this.onPasswordTextChangedListener.accept(text);
            }

            public void keyPressed(KeyEvent event) {
            }
        });
        JLabel passwordLabel = new JLabel("Password");
        container.add(passwordLabel);
        container.add(this.passwordTextField);
        this.loginContainer.add((Component)container, "Center");
    }

    public void createCreateAccountLink() {
        JPanel container = new JPanel();
        final JLabel createAccountLabel = new JLabel("Don't have an account? Create one.");
        createAccountLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        createAccountLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop desktop = Desktop.getDesktop();
                    URI flipperFrontendURI = new URI("https://www.osrs-flipper.com");
                    desktop.browse(flipperFrontendURI);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                createAccountLabel.setForeground(ColorScheme.BRAND_ORANGE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                createAccountLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            }
        });
        container.add(createAccountLabel);
        this.loginContainer.add((Component)container, "Center");
    }

    public void createLoginButton() {
        JPanel container = new JPanel();
        this.loginButton = new JButton("Login");
        this.loginButton.addActionListener(this.onLoginPressedListener);
        container.add(this.loginButton);
        this.loginContainer.add((Component)container, "Center");
    }
}

