/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.views.flips;

import com.flipper.helpers.Numbers;
import com.flipper.helpers.Timestamps;
import com.flipper.helpers.UiUtilities;
import com.flipper.models.Flip;
import com.flipper.views.components.DeleteButton;
import com.flipper.views.components.ItemHeader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.UUID;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;

public class FlipPanel
extends JPanel {
    private Flip flip;
    private static int LABEL_COUNT = 6;
    private JPanel container = new JPanel();
    private JPanel itemInfo = new JPanel(new BorderLayout());
    private JPanel leftInfoTextPanel = new JPanel(new GridLayout(LABEL_COUNT, 1));
    private JPanel rightValuesPanel = new JPanel(new GridLayout(LABEL_COUNT, 1));

    public FlipPanel(Flip flip, ItemManager itemManager, Consumer<UUID> removeFlipConsumer, boolean isPrompt) {
        this.flip = flip;
        ItemComposition itemComp = itemManager.getItemComposition(flip.getItemId());
        DeleteButton deleteFlipButton = new DeleteButton(action -> {
            int input;
            String describedBuy = flip.describeFlip(itemComp.getName());
            int n = input = isPrompt ? JOptionPane.showConfirmDialog(null, "Delete flip of " + describedBuy + "?") : 0;
            if (input == 0) {
                removeFlipConsumer.accept(flip.getId());
                this.setVisible(false);
            }
        });
        this.setLayout(new BorderLayout());
        this.container.setLayout(new BorderLayout());
        this.container.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.container.add((Component)new ItemHeader(flip.getItemId(), 0, itemComp.getName(), itemManager, false, deleteFlipButton), "North");
        this.constructItemInfo();
        this.setBorder(new EmptyBorder(0, 5, 3, 5));
        this.add((Component)this.container, "North");
    }

    private void constructItemInfo() {
        this.constructLeftLabels();
        this.constructRightLabels();
        this.itemInfo.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.itemInfo.add((Component)this.leftInfoTextPanel, "West");
        this.itemInfo.add((Component)this.rightValuesPanel, "East");
        this.itemInfo.setBorder(UiUtilities.ITEM_INFO_BORDER);
        this.container.add((Component)this.itemInfo, "Center");
    }

    private JLabel newLeftLabel(String text) {
        JLabel newJLabel = new JLabel(text);
        newJLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        newJLabel.setBorder(new EmptyBorder(0, 0, 2, 0));
        return newJLabel;
    }

    private void addLeftLabel(JLabel newLeftLabel) {
        this.leftInfoTextPanel.add(newLeftLabel);
    }

    private void constructLeftLabels() {
        this.leftInfoTextPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JLabel amountFlippedLabel = this.newLeftLabel("Amount Flipped:");
        JLabel profitEachLabel = this.newLeftLabel("Profit Per:");
        JLabel totalProfitLabel = this.newLeftLabel("Total Profit:");
        JLabel buyPrice = this.newLeftLabel("Buy Price:");
        JLabel sellPrice = this.newLeftLabel("Sell Price:");
        JLabel flipCreatedAt = this.newLeftLabel("Date:");
        this.addLeftLabel(amountFlippedLabel);
        this.addLeftLabel(profitEachLabel);
        this.addLeftLabel(totalProfitLabel);
        this.addLeftLabel(buyPrice);
        this.addLeftLabel(sellPrice);
        this.addLeftLabel(flipCreatedAt);
        this.leftInfoTextPanel.setBorder(new EmptyBorder(2, 5, 2, 10));
    }

    private JLabel newRightLabel(String value, Color fontColor) {
        JLabel newRightLabel = new JLabel(value);
        newRightLabel.setHorizontalAlignment(4);
        newRightLabel.setForeground(fontColor);
        newRightLabel.setBorder(new EmptyBorder(0, 0, 2, 0));
        return newRightLabel;
    }

    private void addRightLabel(JLabel newRightLabel) {
        this.rightValuesPanel.add(newRightLabel);
    }

    private void constructRightLabels() {
        this.rightValuesPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        int totalProfit = this.flip.getTotalProfit();
        int quantity = this.flip.getQuantity();
        int profitEach = quantity != 0 ? totalProfit / quantity : 0;
        String amountFlippedText = Integer.toString(this.flip.getQuantity());
        String totalProfitText = Integer.toString(totalProfit);
        String profitEachText = Integer.toString(profitEach);
        JLabel amountFlippedLabel = this.newRightLabel(Numbers.numberWithCommas(amountFlippedText), ColorScheme.GRAND_EXCHANGE_ALCH);
        Color profitEachColor = profitEach > 0 ? ColorScheme.GRAND_EXCHANGE_ALCH : ColorScheme.PROGRESS_ERROR_COLOR;
        JLabel profitEachLabel = this.newRightLabel(Numbers.numberWithCommas(profitEachText), profitEachColor);
        Color profitColor = this.flip.getTotalProfit() > 0 ? ColorScheme.GRAND_EXCHANGE_ALCH : ColorScheme.PROGRESS_ERROR_COLOR;
        JLabel totalProfitLabel = this.newRightLabel(Numbers.numberWithCommas(totalProfitText), profitColor);
        JLabel buyPrice = this.newRightLabel(Numbers.numberWithCommas(this.flip.getBuyPrice()), ColorScheme.GRAND_EXCHANGE_ALCH);
        JLabel sellPrice = this.newRightLabel(Numbers.numberWithCommas(this.flip.getSellPrice()), ColorScheme.GRAND_EXCHANGE_ALCH);
        JLabel flipCreatedAt = this.newRightLabel(Timestamps.format(this.flip.getCreatedAt()), ColorScheme.GRAND_EXCHANGE_ALCH);
        this.addRightLabel(amountFlippedLabel);
        this.addRightLabel(profitEachLabel);
        this.addRightLabel(totalProfitLabel);
        this.addRightLabel(buyPrice);
        this.addRightLabel(sellPrice);
        this.addRightLabel(flipCreatedAt);
        this.rightValuesPanel.setBorder(new EmptyBorder(2, 5, 2, 10));
    }
}

