/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.views.components;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.function.Consumer;
import javax.swing.JTextField;
import javax.swing.Timer;

public class SearchBar
extends JTextField {
    private Timer timer;
    private final String ph = "Search";

    public SearchBar(final Consumer<String> onSearchTextChanged) {
        this.addKeyListener((KeyListener)new net.runelite.client.input.KeyListener(){

            public void keyTyped(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                if (SearchBar.this.timer == null) {
                    SearchBar.this.timer = new Timer(500, action -> {
                        String text = SearchBar.this.getText();
                        onSearchTextChanged.accept(text);
                    });
                    SearchBar.this.timer.setRepeats(false);
                } else {
                    SearchBar.this.timer.restart();
                }
            }

            public void keyPressed(KeyEvent event) {
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (super.getText().length() > 0 || "Search" == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(super.getDisabledTextColor());
        g2.drawString("Search", this.getInsets().left, g.getFontMetrics().getMaxAscent() + this.getInsets().top);
    }
}

