/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.views.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public class Pagination {
    private Consumer<Object> renderItemCallback;
    private Runnable buildViewCallback;
    private int itemsPerPage;
    private int page;

    public Pagination(Consumer<Object> renderItemCallback, int itemsPerPage, Runnable buildViewCallback) {
        this.itemsPerPage = itemsPerPage;
        this.renderItemCallback = renderItemCallback;
        this.page = 1;
        this.buildViewCallback = buildViewCallback;
    }

    public void resetPage() {
        this.page = 1;
    }

    public <T> void renderList(List<T> items) {
        int startIndex;
        int endIndex = items.size() - this.page * this.itemsPerPage - 1;
        if (endIndex < 0) {
            endIndex = -1;
        }
        for (int i = startIndex = items.size() - (this.page - 1) * this.itemsPerPage - 1; i > endIndex; --i) {
            this.renderItemCallback.accept(items.get(i));
        }
    }

    public <T> void renderFromBeginning(List<T> items) {
        int startIndex = (this.page - 1) * this.itemsPerPage;
        int endIndex = this.page * this.itemsPerPage - 1;
        if (endIndex > items.size()) {
            endIndex = items.size();
        }
        for (int i = startIndex; i < endIndex; ++i) {
            this.renderItemCallback.accept(items.get(i));
        }
    }

    public <T> JPanel getComponent(List<T> items) {
        JPanel container = new JPanel(new BorderLayout());
        final int numberOfPages = (int)Math.round(Math.ceil((double)items.size() * 1.0 / (double)this.itemsPerPage));
        final JLabel previous = new JLabel("<");
        previous.setFont(FontManager.getRunescapeBoldFont());
        previous.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        previous.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Pagination.this.page != 1) {
                    --Pagination.this.page;
                    Pagination.this.buildViewCallback.run();
                } else {
                    Pagination.this.page = numberOfPages;
                    Pagination.this.buildViewCallback.run();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                previous.setForeground(ColorScheme.BRAND_ORANGE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                previous.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            }
        });
        JLabel pageLabel = new JLabel(this.page + " of " + numberOfPages);
        pageLabel.setHorizontalAlignment(0);
        final JLabel next = new JLabel(">");
        next.setFont(FontManager.getRunescapeBoldFont());
        next.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        next.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Pagination.this.page < numberOfPages) {
                    ++Pagination.this.page;
                    Pagination.this.buildViewCallback.run();
                } else {
                    Pagination.this.page = 1;
                    Pagination.this.buildViewCallback.run();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                next.setForeground(ColorScheme.BRAND_ORANGE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                next.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            }
        });
        container.add((Component)previous, "West");
        container.add((Component)pageLabel, "Center");
        container.add((Component)next, "East");
        container.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        return container;
    }
}

