/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.views.components;

import com.flipper.helpers.Numbers;
import com.flipper.helpers.UiUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.AsyncBufferedImage;

public class ItemHeader
extends JPanel {
    private ItemManager itemManager;
    private int itemId;
    private int pricePer;
    private String itemName;
    private JPanel topRightContainer;
    private JLabel costPerLabel;

    public ItemHeader(int itemId, int pricePer, String itemName, ItemManager itemManager, final boolean isAddCostPer, final JButton hoverButton) {
        this.itemId = itemId;
        this.pricePer = pricePer;
        this.itemName = itemName;
        this.itemManager = itemManager;
        this.setLayout(new BorderLayout());
        this.topRightContainer = new JPanel();
        this.topRightContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        JPanel itemIconPanel = this.constructItemIcon();
        JLabel itemNameLabel = this.constructItemName();
        if (isAddCostPer) {
            this.costPerLabel = this.constructCostPerLabel();
            this.topRightContainer.add(this.costPerLabel);
        }
        hoverButton.setVisible(false);
        this.topRightContainer.add(hoverButton);
        this.add((Component)this.topRightContainer, "East");
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        this.add((Component)itemIconPanel, "West");
        this.add((Component)itemNameLabel, "Center");
        this.setBorder(new EmptyBorder(2, 1, 2, 5));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                hoverButton.setVisible(true);
                if (isAddCostPer) {
                    ItemHeader.this.costPerLabel.setVisible(false);
                }
            }

            @Override
            public void mouseExited(MouseEvent me) {
                if (isAddCostPer) {
                    ItemHeader.this.costPerLabel.setVisible(true);
                }
                hoverButton.setVisible(false);
            }
        });
        hoverButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                hoverButton.setVisible(true);
                if (isAddCostPer) {
                    ItemHeader.this.costPerLabel.setVisible(false);
                }
            }

            @Override
            public void mouseExited(MouseEvent me) {
                if (isAddCostPer) {
                    ItemHeader.this.costPerLabel.setVisible(true);
                }
                hoverButton.setVisible(false);
            }
        });
    }

    private JPanel constructItemIcon() {
        AsyncBufferedImage itemImage = this.itemManager.getImage(this.itemId);
        JLabel itemIcon = new JLabel();
        itemIcon.setAlignmentX(0.0f);
        itemIcon.setPreferredSize(UiUtilities.ICON_SIZE);
        if (itemImage != null) {
            itemImage.addTo(itemIcon);
        }
        JPanel itemIconPanel = new JPanel(new BorderLayout());
        itemIconPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        itemIconPanel.add((Component)itemIcon, "West");
        return itemIconPanel;
    }

    private JLabel constructItemName() {
        JLabel itemName = new JLabel(this.itemName, 0);
        itemName.setForeground(Color.WHITE);
        itemName.setFont(FontManager.getRunescapeBoldFont());
        itemName.setPreferredSize(new Dimension(0, 0));
        return itemName;
    }

    private JLabel constructCostPerLabel() {
        String costPerString = Numbers.numberWithCommas(this.pricePer);
        JLabel costPerLabel = new JLabel(costPerString + " gp");
        costPerLabel.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        return costPerLabel;
    }
}

